/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.LocalizedQueueConnectionFactory;
import org.springframework.amqp.rabbit.core.BatchingRabbitTemplate;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.core.support.BatchingStrategy;
import org.springframework.amqp.rabbit.core.support.SimpleBatchingStrategy;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.amqp.rabbit.retry.RepublishMessageRecoverer;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.postprocessor.DelegatingDecompressingPostProcessor;
import org.springframework.amqp.support.postprocessor.GZipPostProcessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.rabbit.RabbitCommonProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitProducerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RabbitMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<RabbitConsumerProperties>, ExtendedProducerProperties<RabbitProducerProperties>, Queue, Exchange>
implements ExtendedPropertiesBinder<MessageChannel, RabbitConsumerProperties, RabbitProducerProperties> {
    private static final AnonymousQueue.Base64UrlNamingStrategy ANONYMOUS_GROUP_NAME_GENERATOR = new AnonymousQueue.Base64UrlNamingStrategy("anonymous.");
    private static final String DEAD_LETTER_EXCHANGE = "DLX";
    private static final MessagePropertiesConverter inboundMessagePropertiesConverter = new DefaultMessagePropertiesConverter(){

        public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
            MessageProperties properties = super.toMessageProperties(source, envelope, charset);
            properties.setDeliveryMode(null);
            return properties;
        }
    };
    private final RabbitAdmin rabbitAdmin;
    private final GenericApplicationContext autoDeclareContext = new GenericApplicationContext();
    private final RabbitProperties rabbitProperties;
    private ConnectionFactory connectionFactory;
    private MessagePostProcessor decompressingPostProcessor = new DelegatingDecompressingPostProcessor();
    private MessagePostProcessor compressingPostProcessor = new GZipPostProcessor();
    private volatile String[] adminAddresses;
    private volatile String[] nodes;
    private volatile boolean clustered;
    private RabbitExtendedBindingProperties extendedBindingProperties = new RabbitExtendedBindingProperties();

    public RabbitMessageChannelBinder(ConnectionFactory connectionFactory, RabbitProperties rabbitProperties) {
        super(true, new String[0]);
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        Assert.notNull((Object)rabbitProperties, (String)"rabbitProperties must not be null");
        this.connectionFactory = connectionFactory;
        this.rabbitProperties = rabbitProperties;
        this.rabbitAdmin = new RabbitAdmin(connectionFactory);
        this.autoDeclareContext.refresh();
        this.rabbitAdmin.setApplicationContext((ApplicationContext)this.autoDeclareContext);
        this.rabbitAdmin.setIgnoreDeclarationExceptions(true);
        this.rabbitAdmin.afterPropertiesSet();
    }

    public void setDecompressingPostProcessor(MessagePostProcessor decompressingPostProcessor) {
        this.decompressingPostProcessor = decompressingPostProcessor;
    }

    public void setCompressingPostProcessor(MessagePostProcessor compressingPostProcessor) {
        this.compressingPostProcessor = compressingPostProcessor;
    }

    public void setAdminAddresses(String[] adminAddresses) {
        this.adminAddresses = Arrays.copyOf(adminAddresses, adminAddresses.length);
    }

    public void setNodes(String[] nodes) {
        this.nodes = Arrays.copyOf(nodes, nodes.length);
        this.clustered = nodes.length > 1;
    }

    public void setExtendedBindingProperties(RabbitExtendedBindingProperties extendedBindingProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
    }

    public void onInit() {
        if (this.clustered) {
            String[] addresses = StringUtils.commaDelimitedListToStringArray((String)this.rabbitProperties.getAddresses());
            Assert.state((addresses.length == this.adminAddresses.length && addresses.length == this.nodes.length ? 1 : 0) != 0, (String)"'addresses', 'adminAddresses', and 'nodes' properties must have equal length");
            this.connectionFactory = new LocalizedQueueConnectionFactory(this.connectionFactory, addresses, this.adminAddresses, this.nodes, this.rabbitProperties.getVirtualHost(), this.rabbitProperties.getUsername(), this.rabbitProperties.getPassword(), this.rabbitProperties.getSsl().isEnabled(), this.rabbitProperties.getSsl().getKeyStore(), this.rabbitProperties.getSsl().getTrustStore(), this.rabbitProperties.getSsl().getKeyStorePassword(), this.rabbitProperties.getSsl().getTrustStorePassword());
        }
    }

    public RabbitConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public RabbitProducerProperties getExtendedProducerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    protected MessageProducer createConsumerEndpoint(String name, String group, Queue destination, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        DirectChannel convertingBridgeChannel = new DirectChannel();
        convertingBridgeChannel.setBeanFactory((BeanFactory)this.getBeanFactory());
        String baseQueueName = this.baseQueueName(name, group);
        convertingBridgeChannel.setBeanName(baseQueueName + ".bridge");
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(this.connectionFactory);
        listenerContainer.setAcknowledgeMode(((RabbitConsumerProperties)properties.getExtension()).getAcknowledgeMode());
        listenerContainer.setChannelTransacted(((RabbitConsumerProperties)properties.getExtension()).isTransacted());
        listenerContainer.setDefaultRequeueRejected(((RabbitConsumerProperties)properties.getExtension()).isRequeueRejected());
        int concurrency = properties.getConcurrency();
        concurrency = concurrency > 0 ? concurrency : 1;
        listenerContainer.setConcurrentConsumers(concurrency);
        int maxConcurrency = ((RabbitConsumerProperties)properties.getExtension()).getMaxConcurrency();
        if (maxConcurrency > concurrency) {
            listenerContainer.setMaxConcurrentConsumers(maxConcurrency);
        }
        listenerContainer.setPrefetchCount(((RabbitConsumerProperties)properties.getExtension()).getPrefetch());
        listenerContainer.setRecoveryInterval(((RabbitConsumerProperties)properties.getExtension()).getRecoveryInterval());
        listenerContainer.setTxSize(((RabbitConsumerProperties)properties.getExtension()).getTxSize());
        listenerContainer.setTaskExecutor((Executor)new SimpleAsyncTaskExecutor(destination.getName() + "-"));
        listenerContainer.setQueues(new Queue[]{destination});
        if (properties.getMaxAttempts() > 1 || ((RabbitConsumerProperties)properties.getExtension()).isRepublishToDlq()) {
            RetryOperationsInterceptor retryInterceptor = (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().retryOperations((RetryOperations)this.buildRetryTemplate((ConsumerProperties)properties)).recoverer(this.determineRecoverer(baseQueueName, ((RabbitConsumerProperties)properties.getExtension()).getPrefix(), ((RabbitConsumerProperties)properties.getExtension()).isRepublishToDlq())).build();
            listenerContainer.setAdviceChain(new Advice[]{retryInterceptor});
        }
        listenerContainer.setAfterReceivePostProcessors(new MessagePostProcessor[]{this.decompressingPostProcessor});
        listenerContainer.setMessagePropertiesConverter(inboundMessagePropertiesConverter);
        listenerContainer.afterPropertiesSet();
        AmqpInboundChannelAdapter adapter = new AmqpInboundChannelAdapter((AbstractMessageListenerContainer)listenerContainer);
        adapter.setBeanFactory((BeanFactory)this.getBeanFactory());
        adapter.setBeanName("inbound." + baseQueueName);
        DefaultAmqpHeaderMapper mapper = DefaultAmqpHeaderMapper.inboundMapper();
        mapper.setRequestHeaderNames(((RabbitConsumerProperties)properties.getExtension()).getRequestHeaderPatterns());
        mapper.setReplyHeaderNames(((RabbitConsumerProperties)properties.getExtension()).getReplyHeaderPatterns());
        adapter.setHeaderMapper((AmqpHeaderMapper)mapper);
        adapter.afterPropertiesSet();
        return adapter;
    }

    protected void afterUnbindConsumer(String name, String group, ExtendedConsumerProperties<RabbitConsumerProperties> consumerProperties) {
        this.cleanAutoDeclareContext(((RabbitConsumerProperties)consumerProperties.getExtension()).getPrefix(), this.baseQueueName(name, group));
    }

    protected Queue createConsumerDestinationIfNecessary(String name, String group, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        Queue queue;
        boolean durable;
        String baseQueueName;
        boolean anonymous = !StringUtils.hasText((String)group);
        String string = baseQueueName = anonymous ? this.groupedName(name, ANONYMOUS_GROUP_NAME_GENERATOR.generateName()) : this.groupedName(name, group);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("declaring queue for inbound: " + baseQueueName + ", bound to: " + name));
        }
        String prefix = ((RabbitConsumerProperties)properties.getExtension()).getPrefix();
        String exchangeName = RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name);
        Exchange exchange = this.buildExchange((RabbitCommonProperties)properties.getExtension(), exchangeName);
        if (((RabbitConsumerProperties)properties.getExtension()).isDeclareExchange()) {
            this.declareExchange(exchangeName, exchange);
        }
        String queueName = RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)baseQueueName);
        boolean partitioned = !anonymous && properties.isPartitioned();
        boolean bl = durable = !anonymous && ((RabbitConsumerProperties)properties.getExtension()).isDurableSubscription();
        if (anonymous) {
            queue = new Queue(queueName, false, true, true);
        } else {
            if (partitioned) {
                String partitionSuffix = "-" + properties.getInstanceIndex();
                queueName = queueName + partitionSuffix;
            }
            queue = durable ? new Queue(queueName, true, false, false, this.queueArgs(queueName, ((RabbitConsumerProperties)properties.getExtension()).getPrefix(), ((RabbitConsumerProperties)properties.getExtension()).isAutoBindDlq())) : new Queue(queueName, false, false, true);
        }
        this.declareQueue(queueName, queue);
        if (((RabbitConsumerProperties)properties.getExtension()).isBindQueue()) {
            this.declareConsumerBindings(name, properties, exchange, partitioned, queue);
        }
        if (durable) {
            this.autoBindDLQ(RabbitMessageChannelBinder.applyPrefix((String)((RabbitConsumerProperties)properties.getExtension()).getPrefix(), (String)baseQueueName), queueName, ((RabbitConsumerProperties)properties.getExtension()).getPrefix(), ((RabbitConsumerProperties)properties.getExtension()).isAutoBindDlq());
        }
        return queue;
    }

    private String baseQueueName(String name, String group) {
        return !StringUtils.hasText((String)group) ? this.groupedName(name, ANONYMOUS_GROUP_NAME_GENERATOR.generateName()) : this.groupedName(name, group);
    }

    private Map<String, Object> queueArgs(String queueName, String prefix, boolean bindDlq) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (bindDlq) {
            args.put("x-dead-letter-exchange", RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)DEAD_LETTER_EXCHANGE));
            args.put("x-dead-letter-routing-key", queueName);
        }
        return args;
    }

    private MessageRecoverer determineRecoverer(String name, String prefix, boolean republish) {
        if (republish) {
            RabbitTemplate errorTemplate = new RabbitTemplate(this.connectionFactory);
            return new RepublishMessageRecoverer((AmqpTemplate)errorTemplate, this.deadLetterExchangeName(prefix), RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name));
        }
        return new RejectAndDontRequeueRecoverer();
    }

    protected Exchange createProducerDestinationIfNecessary(String name, ExtendedProducerProperties<RabbitProducerProperties> producerProperties) {
        String exchangeName = RabbitMessageChannelBinder.applyPrefix((String)((RabbitProducerProperties)producerProperties.getExtension()).getPrefix(), (String)name);
        Exchange exchange = this.buildExchange((RabbitCommonProperties)producerProperties.getExtension(), exchangeName);
        if (((RabbitProducerProperties)producerProperties.getExtension()).isDeclareExchange()) {
            this.declareExchange(exchangeName, exchange);
        }
        return exchange;
    }

    protected MessageHandler createProducerMessageHandler(Exchange exchange, ExtendedProducerProperties<RabbitProducerProperties> properties) throws Exception {
        String prefix = ((RabbitProducerProperties)properties.getExtension()).getPrefix();
        String exchangeName = exchange.getName();
        String destination = StringUtils.isEmpty((Object)prefix) ? exchangeName : exchangeName.substring(prefix.length());
        AmqpOutboundEndpoint endpoint = new AmqpOutboundEndpoint((AmqpTemplate)this.buildRabbitTemplate((RabbitProducerProperties)properties.getExtension()));
        endpoint.setExchangeName(exchange.getName());
        RabbitProducerProperties extendedProperties = (RabbitProducerProperties)properties.getExtension();
        String routingKeyExpression = extendedProperties.getRoutingKeyExpression();
        if (!properties.isPartitioned()) {
            if (routingKeyExpression == null) {
                endpoint.setRoutingKey(destination);
            } else {
                endpoint.setRoutingKeyExpressionString(routingKeyExpression);
            }
        } else if (routingKeyExpression == null) {
            endpoint.setRoutingKeyExpressionString(this.buildPartitionRoutingExpression(destination, false));
        } else {
            endpoint.setRoutingKeyExpressionString(this.buildPartitionRoutingExpression(routingKeyExpression, true));
        }
        if (extendedProperties.getDelayExpression() != null) {
            endpoint.setDelayExpressionString(extendedProperties.getDelayExpression());
        }
        for (String requiredGroupName : properties.getRequiredGroups()) {
            String baseQueueName = exchangeName + "." + requiredGroupName;
            if (!properties.isPartitioned()) {
                Queue queue = new Queue(baseQueueName, true, false, false, this.queueArgs(baseQueueName, prefix, extendedProperties.isAutoBindDlq()));
                this.declareQueue(baseQueueName, queue);
                this.autoBindDLQ(baseQueueName, baseQueueName, extendedProperties.getPrefix(), extendedProperties.isAutoBindDlq());
                if (!extendedProperties.isBindQueue()) continue;
                this.notPartitionedBinding(exchange, queue, extendedProperties);
                continue;
            }
            for (int i = 0; i < properties.getPartitionCount(); ++i) {
                String partitionSuffix = "-" + i;
                String partitionQueueName = baseQueueName + partitionSuffix;
                Queue queue = new Queue(partitionQueueName, true, false, false, this.queueArgs(partitionQueueName, extendedProperties.getPrefix(), extendedProperties.isAutoBindDlq()));
                this.declareQueue(queue.getName(), queue);
                this.autoBindDLQ(baseQueueName, baseQueueName + partitionSuffix, extendedProperties.getPrefix(), extendedProperties.isAutoBindDlq());
                if (!extendedProperties.isBindQueue()) continue;
                this.partitionedBinding(destination, exchange, queue, extendedProperties, i);
            }
        }
        DefaultAmqpHeaderMapper mapper = DefaultAmqpHeaderMapper.outboundMapper();
        mapper.setRequestHeaderNames(extendedProperties.getRequestHeaderPatterns());
        mapper.setReplyHeaderNames(extendedProperties.getReplyHeaderPatterns());
        endpoint.setHeaderMapper((AmqpHeaderMapper)mapper);
        endpoint.setDefaultDeliveryMode(extendedProperties.getDeliveryMode());
        endpoint.setBeanFactory((BeanFactory)this.getBeanFactory());
        endpoint.afterPropertiesSet();
        return endpoint;
    }

    private String buildPartitionRoutingExpression(String expressionRoot, boolean rootIsExpression) {
        return rootIsExpression ? expressionRoot + " + '-' + headers['" + "partition" + "']" : "'" + expressionRoot + "-' + headers['" + "partition" + "']";
    }

    private RabbitTemplate buildRabbitTemplate(RabbitProducerProperties properties) {
        RabbitTemplate rabbitTemplate;
        if (properties.isBatchingEnabled()) {
            SimpleBatchingStrategy batchingStrategy = new SimpleBatchingStrategy(properties.getBatchSize(), properties.getBatchBufferLimit(), (long)properties.getBatchTimeout());
            rabbitTemplate = new BatchingRabbitTemplate((BatchingStrategy)batchingStrategy, (TaskScheduler)this.getApplicationContext().getBean("taskScheduler", TaskScheduler.class));
        } else {
            rabbitTemplate = new RabbitTemplate();
        }
        rabbitTemplate.setConnectionFactory(this.connectionFactory);
        if (properties.isCompress()) {
            rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{this.compressingPostProcessor});
        }
        rabbitTemplate.setChannelTransacted(properties.isTransacted());
        rabbitTemplate.afterPropertiesSet();
        return rabbitTemplate;
    }

    private void autoBindDLQ(String baseQueueName, String routingKey, String prefix, boolean autoBindDlq) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("autoBindDLQ=" + autoBindDlq + " for: " + baseQueueName));
        }
        if (autoBindDlq) {
            String dlqName = RabbitMessageChannelBinder.constructDLQName((String)baseQueueName);
            Queue dlq = new Queue(dlqName);
            this.declareQueue(dlqName, dlq);
            String dlxName = this.deadLetterExchangeName(prefix);
            DirectExchange dlx = new DirectExchange(dlxName);
            this.declareExchange(dlxName, (Exchange)dlx);
            this.declareBinding(dlqName, BindingBuilder.bind((Queue)dlq).to(dlx).with(routingKey));
            this.declareBinding(dlqName, BindingBuilder.bind((Queue)dlq).to(dlx).with(baseQueueName));
        }
    }

    private void declareQueue(String beanName, Queue queue) {
        block2: {
            try {
                this.rabbitAdmin.declareQueue(queue);
            }
            catch (AmqpConnectException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Declaration of queue: " + queue.getName() + " deferred - connection not available"));
            }
        }
        this.addToAutoDeclareContext(beanName, queue);
    }

    private Exchange buildExchange(RabbitCommonProperties properties, String exchangeName) {
        try {
            Constructor ctor = ExchangeBuilder.class.getDeclaredConstructor(String.class, String.class);
            ReflectionUtils.makeAccessible(ctor);
            ExchangeBuilder builder = (ExchangeBuilder)ctor.newInstance(exchangeName, properties.getExchangeType());
            if (properties.isExchangeDurable()) {
                builder.durable();
            }
            if (properties.isExchangeAutoDelete()) {
                builder.autoDelete();
            }
            if (properties.isDelayedExchange()) {
                builder.delayed();
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create exchange object", e);
        }
    }

    private void declareExchange(String rootName, Exchange exchange) {
        block2: {
            try {
                this.rabbitAdmin.declareExchange(exchange);
            }
            catch (AmqpConnectException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Declaration of exchange: " + exchange.getName() + " deferred - connection not available"));
            }
        }
        this.addToAutoDeclareContext(rootName + ".exchange", exchange);
    }

    private void declareConsumerBindings(String name, ExtendedConsumerProperties<RabbitConsumerProperties> properties, Exchange exchange, boolean partitioned, Queue queue) {
        if (partitioned) {
            this.partitionedBinding(name, exchange, queue, (RabbitCommonProperties)properties.getExtension(), properties.getInstanceIndex());
        } else {
            this.notPartitionedBinding(exchange, queue, (RabbitCommonProperties)properties.getExtension());
        }
    }

    private void partitionedBinding(String destination, Exchange exchange, Queue queue, RabbitCommonProperties extendedProperties, int index) {
        String bindingKey = extendedProperties.getBindingRoutingKey();
        if (bindingKey == null) {
            bindingKey = destination;
        }
        bindingKey = bindingKey + "-" + index;
        if (exchange instanceof TopicExchange) {
            this.declareBinding(queue.getName(), BindingBuilder.bind((Queue)queue).to((TopicExchange)exchange).with(bindingKey));
        } else if (exchange instanceof DirectExchange) {
            this.declareBinding(queue.getName(), BindingBuilder.bind((Queue)queue).to((DirectExchange)exchange).with(bindingKey));
        } else {
            if (exchange instanceof FanoutExchange) {
                throw new IllegalStateException("A fanout exchange is not appropriate for partitioned apps");
            }
            throw new IllegalStateException("Cannot bind to a " + exchange.getType() + " exchange");
        }
    }

    private void notPartitionedBinding(Exchange exchange, Queue queue, RabbitCommonProperties extendedProperties) {
        String routingKey = extendedProperties.getBindingRoutingKey();
        if (routingKey == null) {
            routingKey = "#";
        }
        if (exchange instanceof TopicExchange) {
            this.declareBinding(queue.getName(), BindingBuilder.bind((Queue)queue).to((TopicExchange)exchange).with(routingKey));
        } else if (exchange instanceof DirectExchange) {
            this.declareBinding(queue.getName(), BindingBuilder.bind((Queue)queue).to((DirectExchange)exchange).with(routingKey));
        } else if (exchange instanceof FanoutExchange) {
            this.declareBinding(queue.getName(), BindingBuilder.bind((Queue)queue).to((FanoutExchange)exchange));
        } else {
            throw new IllegalStateException("Cannot bind to a " + exchange.getType() + " exchange");
        }
    }

    private void declareBinding(String rootName, Binding binding) {
        block2: {
            try {
                this.rabbitAdmin.declareBinding(binding);
            }
            catch (AmqpConnectException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Declaration of binding: " + rootName + ".binding deferred - connection not available"));
            }
        }
        this.addToAutoDeclareContext(rootName + ".binding", binding);
    }

    private String deadLetterExchangeName(String prefix) {
        return prefix + DEAD_LETTER_EXCHANGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAutoDeclareContext(String name, Object bean) {
        GenericApplicationContext genericApplicationContext = this.autoDeclareContext;
        synchronized (genericApplicationContext) {
            if (!this.autoDeclareContext.containsBean(name)) {
                this.autoDeclareContext.getBeanFactory().registerSingleton(name, bean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAutoDeclareContext(String prefix, String name) {
        GenericApplicationContext genericApplicationContext = this.autoDeclareContext;
        synchronized (genericApplicationContext) {
            this.removeSingleton(RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name) + ".binding");
            this.removeSingleton(RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name));
            String dlq = RabbitMessageChannelBinder.applyPrefix((String)prefix, (String)name) + ".dlq";
            this.removeSingleton(dlq + ".binding");
            this.removeSingleton(dlq);
        }
    }

    private void removeSingleton(String name) {
        ConfigurableListableBeanFactory beanFactory;
        if (this.autoDeclareContext.containsBean(name) && (beanFactory = this.autoDeclareContext.getBeanFactory()) instanceof DefaultListableBeanFactory) {
            ((DefaultListableBeanFactory)beanFactory).destroySingleton(name);
        }
    }
}

