/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive.shaded.rx.internal.reactivestreams;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.springframework.cloud.stream.reactive.shaded.rx.internal.operators.BackpressureUtils;
import rx.Observable;
import rx.Subscriber;

public class PublisherAdapter<T>
implements Publisher<T> {
    private final Observable<T> observable;

    public PublisherAdapter(Observable<T> observable) {
        this.observable = observable.serialize();
    }

    public void subscribe(final org.reactivestreams.Subscriber<? super T> s) {
        this.observable.subscribe(new Subscriber<T>(){
            private final AtomicBoolean done = new AtomicBoolean();
            private final AtomicLong childRequested = new AtomicLong();

            private void doRequest(long n) {
                if (!this.done.get()) {
                    BackpressureUtils.getAndAddRequest((AtomicLong)this.childRequested, (long)n);
                    this.request(n);
                }
            }

            public void onStart() {
                final AtomicBoolean requested = new AtomicBoolean();
                s.onSubscribe(new Subscription(){

                    public void request(long n) {
                        if (n < 1L) {
                            this.unsubscribe();
                            this.onError(new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
                            return;
                        }
                        requested.set(true);
                        this.doRequest(n);
                    }

                    public void cancel() {
                        this.unsubscribe();
                        this.fireDone();
                    }
                });
                if (!requested.get()) {
                    this.request(0L);
                }
            }

            boolean fireDone() {
                return this.done.compareAndSet(false, true);
            }

            public void onCompleted() {
                if (this.fireDone()) {
                    s.onComplete();
                }
            }

            public void onError(Throwable e) {
                if (this.fireDone()) {
                    s.onError(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(T t) {
                if (!this.done.get()) {
                    if (this.childRequested.get() > 0L) {
                        s.onNext(t);
                        this.childRequested.decrementAndGet();
                    } else {
                        try {
                            this.onError(new IllegalStateException("1.1 source doesn't respect backpressure"));
                        }
                        finally {
                            this.unsubscribe();
                        }
                    }
                }
            }
        });
    }
}

