/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive.shaded.rx.internal.reactivestreams;

import java.util.NoSuchElementException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import rx.Single;
import rx.SingleSubscriber;

public final class PublisherAsSingle<T>
implements Single.OnSubscribe<T> {
    final Publisher<T> publisher;

    public PublisherAsSingle(Publisher<T> publisher) {
        this.publisher = publisher;
    }

    public void call(SingleSubscriber<? super T> t) {
        this.publisher.subscribe(new PublisherAsSingleSubscriber<T>(t));
    }

    static final class PublisherAsSingleSubscriber<T>
    implements Subscriber<T>,
    rx.Subscription {
        final SingleSubscriber<? super T> actual;
        Subscription s;
        T value;
        boolean hasValue;
        boolean done;

        public PublisherAsSingleSubscriber(SingleSubscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            this.s = s;
            this.actual.add((rx.Subscription)this);
            s.request(Long.MAX_VALUE);
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.hasValue) {
                this.done = true;
                this.s.cancel();
                this.actual.onError((Throwable)new IndexOutOfBoundsException("The source Publisher emitted multiple values"));
            } else {
                this.value = t;
                this.hasValue = true;
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                return;
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.hasValue) {
                T v = this.value;
                this.value = null;
                this.actual.onSuccess(v);
            } else {
                this.actual.onError((Throwable)new NoSuchElementException("The source Publisher was empty"));
            }
        }

        public boolean isUnsubscribed() {
            return this.actual.isUnsubscribed();
        }

        public void unsubscribe() {
            this.s.cancel();
        }
    }
}

