/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.binding.MessageChannelStreamListenerResultAdapter;
import org.springframework.cloud.stream.binding.StreamAnnotationCommonMethodUtils;
import org.springframework.cloud.stream.binding.StreamListenerParameterAdapter;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.cloud.stream.reactive.FluxSender;
import org.springframework.cloud.stream.reactive.StreamEmitter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class StreamEmitterAnnotationBeanPostProcessor
implements BeanPostProcessor,
SmartInitializingSingleton,
ApplicationContextAware,
SmartLifecycle {
    private static final Log log = LogFactory.getLog(StreamEmitterAnnotationBeanPostProcessor.class);
    private Collection<StreamListenerParameterAdapter> parameterAdapters;
    private Collection<StreamListenerResultAdapter> resultAdapters;
    private final List<Closeable> closeableFluxResources = new ArrayList<Closeable>();
    private ConfigurableApplicationContext applicationContext;
    private MultiValueMap<Object, Method> mappedStreamEmitterMethods = new LinkedMultiValueMap();
    private volatile boolean running;
    private final Lock lock = new ReentrantLock();

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isTrue((boolean)(applicationContext instanceof ConfigurableApplicationContext), (String)"ConfigurableApplicationContext is required");
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        this.parameterAdapters = this.applicationContext.getBeansOfType(StreamListenerParameterAdapter.class).values();
        this.resultAdapters = new ArrayList(this.applicationContext.getBeansOfType(StreamListenerResultAdapter.class).values());
        this.resultAdapters.add((StreamListenerResultAdapter)new MessageChannelStreamListenerResultAdapter());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        ReflectionUtils.doWithMethods((Class)targetClass, method -> {
            if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, StreamEmitter.class)) {
                this.mappedStreamEmitterMethods.add(bean, (Object)method);
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return bean;
    }

    public void start() {
        try {
            this.lock.lock();
            if (!this.running) {
                this.mappedStreamEmitterMethods.forEach((k, v) -> v.forEach(item -> {
                    Assert.isTrue((item.getAnnotation(Input.class) == null ? 1 : 0) != 0, (String)"A method annotated with @StreamEmitter cannot contain @Input annotations");
                    String methodAnnotatedOutboundName = StreamAnnotationCommonMethodUtils.getOutboundBindingTargetName((Method)item);
                    int outputAnnotationCount = StreamAnnotationCommonMethodUtils.outputAnnotationCount((Method)item);
                    StreamEmitterAnnotationBeanPostProcessor.validateStreamEmitterMethod(item, outputAnnotationCount, methodAnnotatedOutboundName);
                    this.invokeSetupMethodOnToTargetChannel((Method)item, k, methodAnnotatedOutboundName);
                }));
                this.running = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void invokeSetupMethodOnToTargetChannel(Method method, Object bean, String outboundName) {
        Object result;
        Object[] arguments = new Object[method.getParameterCount()];
        Object targetBean = null;
        for (int parameterIndex = 0; parameterIndex < arguments.length; ++parameterIndex) {
            SynthesizingMethodParameter methodParameter = new SynthesizingMethodParameter(method, parameterIndex);
            Class parameterType = methodParameter.getParameterType();
            Object targetReferenceValue = null;
            if (methodParameter.hasParameterAnnotation(Output.class)) {
                targetReferenceValue = AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Output.class));
            } else if (arguments.length == 1 && StringUtils.hasText((String)outboundName)) {
                targetReferenceValue = outboundName;
            }
            if (targetReferenceValue != null) {
                targetBean = this.applicationContext.getBean((String)targetReferenceValue);
                for (StreamListenerParameterAdapter streamListenerParameterAdapter : this.parameterAdapters) {
                    if (!streamListenerParameterAdapter.supports(targetBean.getClass(), (MethodParameter)methodParameter)) continue;
                    arguments[parameterIndex] = streamListenerParameterAdapter.adapt(targetBean, (MethodParameter)methodParameter);
                    if (!(arguments[parameterIndex] instanceof FluxSender)) break;
                    this.closeableFluxResources.add((FluxSender)arguments[parameterIndex]);
                    break;
                }
            } else {
                throw new IllegalStateException("At least one output must be specified");
            }
            Assert.notNull((Object)arguments[parameterIndex], (String)("Cannot convert argument " + parameterIndex + " of " + method + "from " + targetBean.getClass() + " to " + parameterType));
        }
        try {
            result = method.invoke(bean, arguments);
        }
        catch (Exception e) {
            throw new BeanInitializationException("Cannot setup StreamEmitter for " + method, (Throwable)e);
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            if (targetBean == null) {
                targetBean = this.applicationContext.getBean(outboundName);
            }
            boolean streamListenerResultAdapterFound = false;
            for (StreamListenerResultAdapter streamListenerResultAdapter : this.resultAdapters) {
                if (!streamListenerResultAdapter.supports(result.getClass(), targetBean.getClass())) continue;
                Closeable fluxDisposable = streamListenerResultAdapter.adapt(result, targetBean);
                this.closeableFluxResources.add(fluxDisposable);
                streamListenerResultAdapterFound = true;
                break;
            }
            Assert.state((boolean)streamListenerResultAdapterFound, (String)"No suitable adapters are found that can convert the return type");
        }
    }

    private static void validateStreamEmitterMethod(Method method, int outputAnnotationCount, String methodAnnotatedOutboundName) {
        if (StringUtils.hasText((String)methodAnnotatedOutboundName)) {
            Assert.isTrue((outputAnnotationCount == 0 ? 1 : 0) != 0, (String)"@Output annotations are not permitted on method parameters while using the @StreamEmitter and a method-level output specification");
        } else {
            Assert.isTrue((outputAnnotationCount > 0 ? 1 : 0) != 0, (String)"No method level or parameter level @Output annotations are detected. @StreamEmitter requires a method or parameter level @Output annotation.");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            Assert.isTrue((boolean)StringUtils.hasText((String)methodAnnotatedOutboundName), (String)"A method annotated with @StreamEmitter having a return type should also have an outbound target specified at the method level.");
            Assert.isTrue((method.getParameterCount() == 0 ? 1 : 0) != 0, (String)"A method annotated with @StreamEmitter having a return type should not have any method arguments");
        } else if (!StringUtils.hasText((String)methodAnnotatedOutboundName)) {
            int methodArgumentsLength = method.getParameterTypes().length;
            for (int parameterIndex = 0; parameterIndex < methodArgumentsLength; ++parameterIndex) {
                MethodParameter methodParameter = new MethodParameter(method, parameterIndex);
                if (!methodParameter.hasParameterAnnotation(Output.class)) {
                    throw new IllegalArgumentException("A method annotated with @StreamEmitter and void return type without method level @Output annotation requires @Output on each of the method parameter");
                }
                String outboundName = (String)AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Output.class));
                Assert.isTrue((boolean)StringUtils.hasText((String)outboundName), (String)"The @Output annotation must have the name of an input as value");
            }
        }
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.lock.lock();
            if (this.running) {
                for (Closeable closeable : this.closeableFluxResources) {
                    try {
                        closeable.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing reactive source", (Throwable)e);
                    }
                }
                this.running = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }
}

