/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.server.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.schema.server.config.SchemaServerProperties;
import org.springframework.cloud.stream.schema.server.controllers.ServerController;
import org.springframework.cloud.stream.schema.server.repository.SchemaRepository;
import org.springframework.cloud.stream.schema.server.support.AvroSchemaValidator;
import org.springframework.cloud.stream.schema.server.support.SchemaValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@EnableJpaRepositories(basePackageClasses={SchemaRepository.class})
@EnableConfigurationProperties(value={SchemaServerProperties.class})
public class SchemaServerConfiguration {
    @Bean
    public ServerController serverController(SchemaRepository repository) {
        return new ServerController(repository, this.schemaValidators());
    }

    @Bean
    public Map<String, SchemaValidator> schemaValidators() {
        HashMap<String, SchemaValidator> validatorMap = new HashMap<String, SchemaValidator>();
        validatorMap.put("avro", new AvroSchemaValidator());
        return validatorMap;
    }
}

