/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.avro;

import java.lang.reflect.Constructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.cloud.stream.annotation.StreamMessageConverter;
import org.springframework.cloud.stream.schema.avro.AvroMessageConverterProperties;
import org.springframework.cloud.stream.schema.avro.AvroSchemaRegistryClientMessageConverter;
import org.springframework.cloud.stream.schema.avro.AvroSchemaServiceManager;
import org.springframework.cloud.stream.schema.avro.AvroSchemaServiceManagerImpl;
import org.springframework.cloud.stream.schema.avro.SubjectNamingStrategy;
import org.springframework.cloud.stream.schema.client.SchemaRegistryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(name={"org.apache.avro.Schema"})
@ConditionalOnProperty(value={"spring.cloud.stream.schemaRegistryClient.enabled"}, matchIfMissing=true)
@ConditionalOnBean(type={"org.springframework.cloud.stream.schema.client.SchemaRegistryClient"})
@EnableConfigurationProperties(value={AvroMessageConverterProperties.class})
@Import(value={AvroSchemaServiceManagerImpl.class})
public class AvroMessageConverterAutoConfiguration {
    @Autowired
    private AvroMessageConverterProperties avroMessageConverterProperties;
    @Autowired
    private AvroSchemaServiceManager avroSchemaServiceManager;

    @Bean
    @ConditionalOnMissingBean(value={AvroSchemaRegistryClientMessageConverter.class})
    @StreamMessageConverter
    public AvroSchemaRegistryClientMessageConverter avroSchemaMessageConverter(SchemaRegistryClient schemaRegistryClient) {
        AvroSchemaRegistryClientMessageConverter avroSchemaRegistryClientMessageConverter = new AvroSchemaRegistryClientMessageConverter(schemaRegistryClient, this.cacheManager(), this.avroSchemaServiceManager);
        avroSchemaRegistryClientMessageConverter.setDynamicSchemaGenerationEnabled(this.avroMessageConverterProperties.isDynamicSchemaGenerationEnabled());
        if (this.avroMessageConverterProperties.getReaderSchema() != null) {
            avroSchemaRegistryClientMessageConverter.setReaderSchema(this.avroMessageConverterProperties.getReaderSchema());
        }
        if (!ObjectUtils.isEmpty((Object[])this.avroMessageConverterProperties.getSchemaLocations())) {
            avroSchemaRegistryClientMessageConverter.setSchemaLocations(this.avroMessageConverterProperties.getSchemaLocations());
        }
        if (!ObjectUtils.isEmpty((Object[])this.avroMessageConverterProperties.getSchemaImports())) {
            avroSchemaRegistryClientMessageConverter.setSchemaImports(this.avroMessageConverterProperties.getSchemaImports());
        }
        avroSchemaRegistryClientMessageConverter.setPrefix(this.avroMessageConverterProperties.getPrefix());
        try {
            Class<?> clazz = this.avroMessageConverterProperties.getSubjectNamingStrategy();
            Constructor constructor = ReflectionUtils.accessibleConstructor(clazz, (Class[])new Class[0]);
            avroSchemaRegistryClientMessageConverter.setSubjectNamingStrategy((SubjectNamingStrategy)constructor.newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create SubjectNamingStrategy " + this.avroMessageConverterProperties.getSubjectNamingStrategy().toString(), ex);
        }
        return avroSchemaRegistryClientMessageConverter;
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheManager cacheManager() {
        return new ConcurrentMapCacheManager();
    }
}

