/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.client;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.stream.schema.SchemaReference;
import org.springframework.cloud.stream.schema.SchemaRegistrationResponse;
import org.springframework.cloud.stream.schema.client.SchemaRegistryClient;
import org.springframework.util.Assert;

public class CachingRegistryClient
implements SchemaRegistryClient {
    private static final String CACHE_PREFIX = "org.springframework.cloud.stream.schema.client";
    private static final String ID_CACHE = "org.springframework.cloud.stream.schema.client.schemaByIdCache";
    private static final String REF_CACHE = "org.springframework.cloud.stream.schema.client.schemaByReferenceCache";
    private SchemaRegistryClient delegate;
    @Autowired
    private CacheManager cacheManager;

    public CachingRegistryClient(SchemaRegistryClient delegate) {
        Assert.notNull((Object)delegate, (String)"The delegate cannot be null");
        this.delegate = delegate;
    }

    @Override
    public SchemaRegistrationResponse register(String subject, String format, String schema) {
        SchemaRegistrationResponse response = this.delegate.register(subject, format, schema);
        this.cacheManager.getCache(ID_CACHE).put((Object)response.getId(), (Object)schema);
        this.cacheManager.getCache(REF_CACHE).put((Object)response.getSchemaReference(), (Object)schema);
        return response;
    }

    @Override
    @Cacheable(cacheNames={"org.springframework.cloud.stream.schema.client.schemaByReferenceCache"})
    public String fetch(SchemaReference schemaReference) {
        return this.delegate.fetch(schemaReference);
    }

    @Override
    @Cacheable(cacheNames={"org.springframework.cloud.stream.schema.client.schemaByIdCache"})
    public String fetch(int id) {
        return this.delegate.fetch(id);
    }
}

