/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.test.binder;

import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.test.binder.MessageCollector;
import org.springframework.cloud.stream.test.binder.TestSupportBinder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.MessageChannel;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class TestSupportBinderAutoConfiguration {
    private Binder<MessageChannel, ?, ?> messageChannelBinder = new TestSupportBinder();

    @Bean
    public BinderFactory binderFactory() {
        return new BinderFactory(){

            public <T> Binder<T, ? extends ConsumerProperties, ? extends ProducerProperties> getBinder(String configurationName, Class<? extends T> bindableType) {
                return TestSupportBinderAutoConfiguration.this.messageChannelBinder;
            }
        };
    }

    @Bean
    public MessageCollector messageCollector(BinderFactory binderFactory) {
        return ((TestSupportBinder)binderFactory.getBinder(null, MessageChannel.class)).messageCollector();
    }
}

