/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.test.binder;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.cloud.stream.test.binder.MessageCollector;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public class TestSupportBinder
implements Binder<MessageChannel, ConsumerProperties, ProducerProperties> {
    private final MessageCollectorImpl messageCollector = new MessageCollectorImpl();
    private final ConcurrentMap<String, MessageChannel> messageChannels = new ConcurrentHashMap<String, MessageChannel>();

    public Binding<MessageChannel> bindConsumer(String name, String group, MessageChannel inboundBindTarget, ConsumerProperties properties) {
        return new TestBinding(inboundBindTarget, null);
    }

    public Binding<MessageChannel> bindProducer(String name, MessageChannel outboundBindTarget, ProducerProperties properties) {
        final BlockingQueue queue = this.messageCollector.register(outboundBindTarget, properties.isUseNativeEncoding());
        ((SubscribableChannel)outboundBindTarget).subscribe(new MessageHandler(){

            public void handleMessage(Message<?> message) throws MessagingException {
                queue.add(message);
            }
        });
        this.messageChannels.put(name, outboundBindTarget);
        return new TestBinding(outboundBindTarget, this.messageCollector);
    }

    public MessageCollector messageCollector() {
        return this.messageCollector;
    }

    public MessageChannel getChannelForName(String name) {
        return (MessageChannel)this.messageChannels.get(name);
    }

    private static final class InboundMessageConvertingInterceptor
    implements ChannelInterceptor {
        private final DefaultContentTypeResolver contentTypeResolver = new DefaultContentTypeResolver();
        private final CompositeMessageConverterFactory converterFactory = new CompositeMessageConverterFactory();

        private InboundMessageConvertingInterceptor() {
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            Object payload;
            MimeType contentType;
            Class<?> targetClass = null;
            CompositeMessageConverter converter = null;
            MimeType mimeType = contentType = message.getHeaders().containsKey((Object)"originalContentType") ? MimeType.valueOf((String)message.getHeaders().get((Object)"originalContentType").toString()) : MimeType.valueOf((String)this.contentTypeResolver.resolve(message.getHeaders()).toString());
            if (contentType != null && (InboundMessageConvertingInterceptor.equalTypeAndSubType(MessageConverterUtils.X_JAVA_SERIALIZED_OBJECT, contentType) || InboundMessageConvertingInterceptor.equalTypeAndSubType(MessageConverterUtils.X_JAVA_OBJECT, contentType))) {
                message = MessageBuilder.fromMessage(message).setHeader("contentType", (Object)contentType).build();
                converter = InboundMessageConvertingInterceptor.equalTypeAndSubType(MessageConverterUtils.X_JAVA_SERIALIZED_OBJECT, contentType) ? this.converterFactory.getMessageConverterForType(contentType) : this.converterFactory.getMessageConverterForAllRegistered();
                String targetClassName = contentType.getParameter("type");
                if (StringUtils.hasText((String)targetClassName)) {
                    try {
                        targetClass = Class.forName(targetClassName, false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Failed to determine class name for contentType: " + message.getHeaders().get((Object)"originalContentType"), e);
                    }
                }
            }
            if (converter != null) {
                Assert.isTrue((!InboundMessageConvertingInterceptor.equalTypeAndSubType(MessageConverterUtils.X_JAVA_OBJECT, contentType) || targetClass != null ? 1 : 0) != 0, (String)"Cannot deserialize into message since 'contentType` is not encoded with the actual target type.Consider 'application/x-java-object; type=foo.bar.MyClass'");
                payload = converter.fromMessage(message, targetClass);
            } else {
                MimeType deserializeContentType = this.contentTypeResolver.resolve(message.getHeaders());
                if (deserializeContentType == null) {
                    deserializeContentType = contentType;
                }
                payload = deserializeContentType == null ? message.getPayload() : this.deserializePayload(message.getPayload(), deserializeContentType);
            }
            message = MessageBuilder.withPayload((Object)payload).copyHeaders((Map)message.getHeaders()).setHeader("contentType", (Object)contentType).removeHeader("originalContentType").build();
            return message;
        }

        private Object deserializePayload(Object payload, MimeType contentType) {
            if (payload instanceof byte[] && ("text".equalsIgnoreCase(contentType.getType()) || InboundMessageConvertingInterceptor.equalTypeAndSubType(MimeTypeUtils.APPLICATION_JSON, contentType))) {
                payload = new String((byte[])payload, StandardCharsets.UTF_8);
            }
            return payload;
        }

        private static boolean equalTypeAndSubType(MimeType m1, MimeType m2) {
            return m1 != null && m2 != null && m1.getType().equalsIgnoreCase(m2.getType()) && m1.getSubtype().equalsIgnoreCase(m2.getSubtype());
        }
    }

    private static final class TestBinding
    implements Binding<MessageChannel> {
        private final MessageChannel target;
        private final MessageCollectorImpl messageCollector;

        private TestBinding(MessageChannel target, MessageCollectorImpl messageCollector) {
            this.target = target;
            this.messageCollector = messageCollector;
        }

        public void unbind() {
            if (this.messageCollector != null) {
                this.messageCollector.unregister(this.target);
            }
        }
    }

    private static class MessageCollectorImpl
    implements MessageCollector {
        private final Map<MessageChannel, BlockingQueue<Message<?>>> results = new HashMap();

        private MessageCollectorImpl() {
        }

        private BlockingQueue<Message<?>> register(MessageChannel channel, boolean useNativeEncoding) {
            if (!useNativeEncoding) {
                ((AbstractMessageChannel)channel).addInterceptor((ChannelInterceptor)new InboundMessageConvertingInterceptor());
            }
            LinkedBlockingDeque result = new LinkedBlockingDeque();
            Assert.isTrue((!this.results.containsKey(channel) ? 1 : 0) != 0, (String)("Channel [" + channel + "] was already bound"));
            this.results.put(channel, result);
            return result;
        }

        private void unregister(MessageChannel channel) {
            Assert.notNull(this.results.remove(channel), (String)("Trying to unregister a mapping for an unknown channel [" + channel + "]"));
        }

        @Override
        public BlockingQueue<Message<?>> forChannel(MessageChannel channel) {
            BlockingQueue<Message<?>> queue = this.results.get(channel);
            Assert.notNull(queue, (String)("Channel [" + channel + "] was not bound by " + TestSupportBinder.class));
            return queue;
        }
    }
}

