/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;

public abstract class AbstractFromMessageConverter
extends AbstractMessageConverter {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final List<MimeType> targetMimeTypes;

    protected AbstractFromMessageConverter(MimeType targetMimeType) {
        this(new ArrayList<MimeType>(), targetMimeType);
    }

    protected AbstractFromMessageConverter(Collection<MimeType> targetMimeTypes) {
        this(new ArrayList<MimeType>(), targetMimeTypes);
    }

    protected AbstractFromMessageConverter(Collection<MimeType> supportedSourceMimeTypes, MimeType targetMimeType) {
        super(supportedSourceMimeTypes);
        Assert.notNull((Object)targetMimeType, (String)"'targetMimeType' cannot be null");
        this.targetMimeTypes = Collections.singletonList(targetMimeType);
    }

    protected AbstractFromMessageConverter(Collection<MimeType> supportedSourceMimeTypes, Collection<MimeType> targetMimeTypes) {
        super(supportedSourceMimeTypes);
        Assert.notNull(targetMimeTypes, (String)"'targetMimeTypes' cannot be null");
        this.targetMimeTypes = new ArrayList<MimeType>(targetMimeTypes);
    }

    protected AbstractFromMessageConverter(MimeType supportedSourceMimeType, MimeType targetMimeType) {
        this(Collections.singletonList(supportedSourceMimeType), targetMimeType);
    }

    protected AbstractFromMessageConverter(MimeType supportedSourceMimeType, Collection<MimeType> targetMimeTypes) {
        this(Collections.singletonList(supportedSourceMimeType), targetMimeTypes);
    }

    protected abstract Class<?>[] supportedTargetTypes();

    protected abstract Class<?>[] supportedPayloadTypes();

    protected boolean supportsPayloadType(Class<?> clazz) {
        return this.supportsType(clazz, this.supportedPayloadTypes());
    }

    protected boolean supports(Class<?> clazz) {
        return this.supportsType(clazz, this.supportedTargetTypes());
    }

    private boolean supportsType(Class<?> clazz, Class<?>[] supportedTypes) {
        if (supportedTypes != null) {
            for (Class<?> targetType : supportedTypes) {
                if (!ClassUtils.isAssignable(targetType, clazz)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return super.canConvertFrom(message, targetClass) && this.supportsPayloadType(message.getPayload().getClass());
    }

    public boolean supportsTargetMimeType(MimeType mimeType) {
        for (MimeType targetMimeType : this.targetMimeTypes) {
            if (!targetMimeType.includes(mimeType)) continue;
            return true;
        }
        return false;
    }

    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        return false;
    }

    public Object convertToInternal(Object payload, MessageHeaders headers) {
        throw new UnsupportedOperationException("'convertTo' not supported");
    }
}

