/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.messaging.Message;

public class JavaToSerializedMessageConverter
extends AbstractFromMessageConverter {
    public JavaToSerializedMessageConverter() {
        super(MessageConverterUtils.X_JAVA_OBJECT, MessageConverterUtils.X_JAVA_SERIALIZED_OBJECT);
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{byte[].class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{Serializable.class};
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(bos).writeObject(message.getPayload());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return bos.toByteArray();
    }
}

