/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.MimeTypeUtils;

public class PojoToJsonMessageConverter
extends AbstractFromMessageConverter {
    private final ObjectMapper mapper = new ObjectMapper();
    @Value(value="${typeconversion.json.prettyPrint:false}")
    private volatile boolean prettyPrint;

    public PojoToJsonMessageConverter() {
        super(MimeTypeUtils.APPLICATION_JSON);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{String.class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return null;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        String result;
        try {
            result = this.prettyPrint ? this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(message.getPayload()) : this.mapper.writeValueAsString(message.getPayload());
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return result;
    }
}

