/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.BinderException;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binder.PartitionKeyExtractorStrategy;
import org.springframework.cloud.stream.binder.PartitionSelectorStrategy;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.MutableMessageBuilderFactory;
import org.springframework.integration.support.MutableMessageHeaders;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public class MessageConverterConfigurer
implements MessageChannelConfigurer,
BeanFactoryAware,
InitializingBean {
    private final MessageBuilderFactory messageBuilderFactory = new MutableMessageBuilderFactory();
    private final CompositeMessageConverterFactory compositeMessageConverterFactory;
    private final BindingServiceProperties bindingServiceProperties;
    private ConfigurableListableBeanFactory beanFactory;

    public MessageConverterConfigurer(BindingServiceProperties bindingServiceProperties, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        Assert.notNull((Object)compositeMessageConverterFactory, (String)"The message converter factory cannot be null");
        this.bindingServiceProperties = bindingServiceProperties;
        this.compositeMessageConverterFactory = compositeMessageConverterFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"Bean factory cannot be empty");
    }

    @Override
    public void configureInputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, true);
    }

    @Override
    public void configureOutputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, false);
    }

    private void configureMessageChannel(MessageChannel channel, String channelName, boolean input) {
        Assert.isAssignable(AbstractMessageChannel.class, channel.getClass());
        AbstractMessageChannel messageChannel = (AbstractMessageChannel)channel;
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(channelName);
        String contentType = bindingProperties.getContentType();
        ProducerProperties producerProperties = bindingProperties.getProducer();
        if (!input && producerProperties != null && producerProperties.isPartitioned()) {
            messageChannel.addInterceptor((ChannelInterceptor)new PartitioningInterceptor(bindingProperties, this.getPartitionKeyExtractorStrategy(producerProperties), this.getPartitionSelectorStrategy(producerProperties)));
        }
        if (input) {
            messageChannel.addInterceptor((ChannelInterceptor)new InboundMessageConvertingInterceptor());
        }
        if (StringUtils.hasText((String)contentType)) {
            messageChannel.addInterceptor((ChannelInterceptor)new ContentTypeConvertingInterceptor(contentType, input));
        }
    }

    private PartitionKeyExtractorStrategy getPartitionKeyExtractorStrategy(ProducerProperties producerProperties) {
        if (producerProperties.getPartitionKeyExtractorClass() != null) {
            return this.getBean(producerProperties.getPartitionKeyExtractorClass().getName(), PartitionKeyExtractorStrategy.class);
        }
        return null;
    }

    private PartitionSelectorStrategy getPartitionSelectorStrategy(ProducerProperties producerProperties) {
        if (producerProperties.getPartitionSelectorClass() != null) {
            return this.getBean(producerProperties.getPartitionSelectorClass().getName(), PartitionSelectorStrategy.class);
        }
        return new DefaultPartitionSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getBean(String className, Class<T> type) {
        if (this.beanFactory.containsBean(className)) {
            return (T)this.beanFactory.getBean(className, type);
        }
        MessageConverterConfigurer messageConverterConfigurer = this;
        synchronized (messageConverterConfigurer) {
            Object bean;
            Class clazz;
            try {
                clazz = ClassUtils.forName((String)className, (ClassLoader)this.beanFactory.getBeanClassLoader());
            }
            catch (Exception e) {
                throw new BinderException("Failed to load class: " + className, e);
            }
            try {
                bean = clazz.newInstance();
                Assert.isInstanceOf(type, bean);
                this.beanFactory.registerSingleton(className, bean);
                this.beanFactory.initializeBean(bean, className);
            }
            catch (Exception e) {
                throw new BinderException("Failed to instantiate class: " + className, e);
            }
            return bean;
        }
    }

    private static boolean equalTypeAndSubType(MimeType m1, MimeType m2) {
        return m1 != null && m2 != null && m1.getType().equalsIgnoreCase(m2.getType()) && m1.getSubtype().equalsIgnoreCase(m2.getSubtype());
    }

    public static final class InboundMessageConvertingInterceptor
    extends ChannelInterceptorAdapter {
        private final DefaultContentTypeResolver contentTypeResolver = new DefaultContentTypeResolver();
        private final CompositeMessageConverterFactory converterFactory = new CompositeMessageConverterFactory();

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            Object payload;
            MimeType contentType;
            Class<?> targetClass = null;
            CompositeMessageConverter converter = null;
            MimeType mimeType = contentType = message.getHeaders().containsKey((Object)"originalContentType") ? MimeType.valueOf((String)((String)message.getHeaders().get((Object)"originalContentType"))) : this.contentTypeResolver.resolve(message.getHeaders());
            if (contentType != null && (MessageConverterConfigurer.equalTypeAndSubType(MessageConverterUtils.X_JAVA_SERIALIZED_OBJECT, contentType) || MessageConverterConfigurer.equalTypeAndSubType(MessageConverterUtils.X_JAVA_OBJECT, contentType))) {
                message = MessageBuilder.fromMessage(message).setHeader("contentType", (Object)contentType).build();
                converter = MessageConverterConfigurer.equalTypeAndSubType(MessageConverterUtils.X_JAVA_SERIALIZED_OBJECT, contentType) ? this.converterFactory.getMessageConverterForType(contentType) : this.converterFactory.getMessageConverterForAllRegistered();
                String targetClassName = contentType.getParameter("type");
                if (StringUtils.hasText((String)targetClassName)) {
                    try {
                        targetClass = Class.forName(targetClassName, false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Failed to determine class name for contentType: " + message.getHeaders().get((Object)"originalContentType"), e);
                    }
                }
            }
            if (converter != null) {
                Assert.isTrue((!MessageConverterConfigurer.equalTypeAndSubType(MessageConverterUtils.X_JAVA_OBJECT, contentType) || targetClass != null ? 1 : 0) != 0, (String)"Can not deserialize into message since 'contentType` has not being encoded with the actual target type.Consider 'application/x-java-object; type=foo.bar.MyClass'");
                payload = converter.fromMessage(message, targetClass);
            } else {
                MimeType deserializeContentType = this.contentTypeResolver.resolve(message.getHeaders());
                if (deserializeContentType == null) {
                    deserializeContentType = contentType;
                }
                payload = deserializeContentType == null ? message.getPayload() : this.deserializePayload(message.getPayload(), deserializeContentType);
            }
            message = MessageBuilder.withPayload((Object)payload).copyHeaders((Map)message.getHeaders()).setHeader("contentType", (Object)contentType).removeHeader("originalContentType").build();
            return message;
        }

        private Object deserializePayload(Object payload, MimeType contentType) {
            if (payload instanceof byte[] && ("text".equalsIgnoreCase(contentType.getType()) || MessageConverterConfigurer.equalTypeAndSubType(MimeTypeUtils.APPLICATION_JSON, contentType))) {
                payload = new String((byte[])payload, StandardCharsets.UTF_8);
            }
            return payload;
        }
    }

    protected final class PartitioningInterceptor
    extends ChannelInterceptorAdapter {
        private final BindingProperties bindingProperties;
        private final PartitionHandler partitionHandler;

        PartitioningInterceptor(BindingProperties bindingProperties, PartitionKeyExtractorStrategy partitionKeyExtractorStrategy, PartitionSelectorStrategy partitionSelectorStrategy) {
            this.bindingProperties = bindingProperties;
            this.partitionHandler = new PartitionHandler((EvaluationContext)ExpressionUtils.createStandardEvaluationContext((BeanFactory)MessageConverterConfigurer.this.beanFactory), this.bindingProperties.getProducer(), partitionKeyExtractorStrategy, partitionSelectorStrategy);
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            if (!message.getHeaders().containsKey((Object)"scst_partitionOverride")) {
                int partition = this.partitionHandler.determinePartition(message);
                return MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("scst_partition", (Object)partition).build();
            }
            return MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("scst_partition", message.getHeaders().get((Object)"scst_partitionOverride")).removeHeader("scst_partitionOverride").build();
        }
    }

    private final class ContentTypeConvertingInterceptor
    extends ChannelInterceptorAdapter {
        private final MimeType mimeType;
        private final boolean input;
        private final MessageConverter messageConverter;

        private ContentTypeConvertingInterceptor(String contentType, boolean input) {
            this.mimeType = MessageConverterUtils.getMimeType(contentType);
            this.input = input;
            this.messageConverter = MessageConverterConfigurer.this.compositeMessageConverterFactory.getMessageConverterForAllRegistered();
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            Message converted;
            if (message instanceof ErrorMessage) {
                return message;
            }
            Message sentMessage = message;
            if (this.input || message.getPayload() instanceof byte[]) {
                return MessageConverterConfigurer.this.messageBuilderFactory.withPayload(message.getPayload()).copyHeaders((Map)message.getHeaders()).setHeaderIfAbsent("contentType", (Object)this.mimeType).build();
            }
            MutableMessageHeaders headers = new MutableMessageHeaders((Map)message.getHeaders());
            if (!headers.containsKey((Object)"contentType")) {
                headers.put("contentType", (Object)this.mimeType);
            }
            if ((converted = this.messageConverter.toMessage(message.getPayload(), (MessageHeaders)headers)) != null) {
                sentMessage = converted instanceof Message ? converted : MessageConverterConfigurer.this.messageBuilderFactory.withPayload((Object)converted).copyHeaders((Map)message.getHeaders()).setHeaderIfAbsent("contentType", (Object)this.mimeType).build();
            }
            return sentMessage;
        }
    }

    private static class DefaultPartitionSelector
    implements PartitionSelectorStrategy {
        private DefaultPartitionSelector() {
        }

        @Override
        public int selectPartition(Object key, int partitionCount) {
            int hashCode = key.hashCode();
            if (hashCode == Integer.MIN_VALUE) {
                hashCode = 0;
            }
            return Math.abs(hashCode);
        }
    }
}

