/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import org.springframework.cloud.stream.binder.Binding;
import org.springframework.context.Lifecycle;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DefaultBinding<T>
implements Binding<T> {
    protected final String name;
    protected final String group;
    protected final T target;
    protected final Lifecycle lifecycle;

    public DefaultBinding(String name, String group, T target, Lifecycle lifecycle) {
        Assert.notNull(target, (String)"target must not be null");
        this.name = name;
        this.group = group;
        this.target = target;
        this.lifecycle = lifecycle;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public final void unbind() {
        if (this.lifecycle != null) {
            this.lifecycle.stop();
        }
        this.afterUnbind();
    }

    Lifecycle getEndpoint() {
        return this.lifecycle;
    }

    protected void afterUnbind() {
    }

    public String toString() {
        return " Binding [name=" + this.name + ", target=" + this.target + ", lifecycle=" + (this.lifecycle instanceof NamedComponent ? ((NamedComponent)this.lifecycle).getComponentName() : ObjectUtils.nullSafeToString((Object)this.lifecycle)) + "]";
    }
}

