/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.context.Lifecycle;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultBinding<T>
implements Binding<T> {
    private final Log logger = LogFactory.getLog((String)this.getClass().getName());
    protected final String name;
    protected final String group;
    protected final T target;
    protected final Lifecycle lifecycle;

    public DefaultBinding(String name, String group, T target, Lifecycle lifecycle) {
        Assert.notNull(target, (String)"target must not be null");
        this.name = name;
        this.group = group;
        this.target = target;
        this.lifecycle = lifecycle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public boolean isRunning() {
        return this.lifecycle != null && this.lifecycle.isRunning();
    }

    @Override
    public final synchronized void start() {
        if (!this.isRunning()) {
            if (this.lifecycle != null && StringUtils.hasText((String)this.group)) {
                this.lifecycle.start();
            } else {
                this.logger.warn((Object)"Can not re-bind an anonymous binding");
            }
        }
    }

    @Override
    public final synchronized void stop() {
        if (this.isRunning()) {
            this.lifecycle.stop();
        }
    }

    @Override
    public final void unbind() {
        this.stop();
        this.afterUnbind();
    }

    Lifecycle getEndpoint() {
        return this.lifecycle;
    }

    protected void afterUnbind() {
    }

    public String toString() {
        return " Binding [name=" + this.name + ", target=" + this.target + ", lifecycle=" + (this.lifecycle instanceof NamedComponent ? ((NamedComponent)this.lifecycle).getComponentName() : ObjectUtils.nullSafeToString((Object)this.lifecycle)) + "]";
    }
}

