/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.micrometer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

@ConfigurationProperties(prefix="spring.cloud.stream.metrics")
public class ApplicationMetricsProperties
implements EnvironmentAware,
ApplicationContextAware {
    public static final String PREFIX = "spring.cloud.stream.metrics";
    private static final Bindable<Map<String, String>> STRING_STRING_MAP = Bindable.mapOf(String.class, String.class);
    @Value(value="${spring.application.name:${vcap.application.name:${spring.config.name:application}}}")
    private String key;
    private String[] properties;
    private String scheduleInterval;
    private Map<String, Object> exportProperties;
    private Environment environment;
    private ApplicationContext applicationContext;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }

    public Map<String, Object> getExportProperties() {
        if (this.exportProperties == null) {
            this.exportProperties = this.buildExportProperties();
        }
        return this.exportProperties;
    }

    public String getScheduleInterval() {
        return this.scheduleInterval;
    }

    public void setScheduleInterval(String scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }

    private boolean isMatch(String name, String[] includes, String[] excludes) {
        if (ObjectUtils.isEmpty((Object[])includes) || PatternMatchUtils.simpleMatch((String[])includes, (String)name)) {
            return !PatternMatchUtils.simpleMatch((String[])excludes, (String)name);
        }
        return false;
    }

    private Map<String, Object> buildExportProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (!ObjectUtils.isEmpty((Object[])this.properties)) {
            Map<String, String> target = this.bindProperties();
            BeanExpressionResolver beanExpressionResolver = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getBeanExpressionResolver();
            BeanExpressionContext expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory(), null);
            for (Map.Entry<String, String> entry : target.entrySet()) {
                if (!this.isMatch(entry.getKey(), this.properties, null)) continue;
                String stringValue = ObjectUtils.nullSafeToString((Object)entry.getValue());
                String exportedValue = null;
                if (stringValue != null) {
                    exportedValue = stringValue.startsWith("#{") ? beanExpressionResolver.evaluate(this.environment.resolvePlaceholders(stringValue), expressionContext) : this.environment.resolvePlaceholders(stringValue);
                }
                props.put(entry.getKey(), exportedValue);
            }
        }
        return props;
    }

    private Map<String, String> bindProperties() {
        BindResult bindResult = Binder.get((Environment)this.environment).bind("", STRING_STRING_MAP);
        HashMap<String, String> target = bindResult.isBound() ? (HashMap<String, String>)bindResult.get() : new HashMap<String, String>();
        return target;
    }
}

