/*
 * Copyright 2016-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.stream.binder;

/**
 * @param <T> extension type
 * @author Marius Bogoevici
 */
public class ExtendedProducerProperties<T> extends ProducerProperties {

	private T extension;

	public ExtendedProducerProperties(T extension) {
		this.extension = extension;
	}

	public T getExtension() {
		return this.extension;
	}

}
