/*
 * Copyright 2023-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.stream.function;

import java.util.HashMap;
import java.util.Map;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author Oleg Zhurakousky
 * @author Soby Chacko
 * @since 4.0.2
 */
@ConfigurationProperties("spring.cloud.stream.function")
public class StreamFunctionConfigurationProperties {
	private Map<String, String> bindings = new HashMap<>();

	public Map<String, String> getBindings() {
		return this.bindings;
	}

	public void setBindings(Map<String, String> bindings) {
		this.bindings = bindings;
	}
}
