/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.configuration;

import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.cloud.task.batch.configuration.TaskBatchProperties;
import org.springframework.cloud.task.batch.handler.TaskJobLauncherApplicationRunner;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TaskJobLauncherApplicationRunnerFactoryBean
implements FactoryBean<TaskJobLauncherApplicationRunner> {
    private JobLauncher jobLauncher;
    private JobExplorer jobExplorer;
    private List<Job> jobs;
    private String jobName;
    private JobRegistry jobRegistry;
    private Integer order = 0;
    private TaskBatchProperties taskBatchProperties;
    private JobRepository jobRepository;

    public TaskJobLauncherApplicationRunnerFactoryBean(JobLauncher jobLauncher, JobExplorer jobExplorer, List<Job> jobs, TaskBatchProperties taskBatchProperties, JobRegistry jobRegistry, JobRepository jobRepository, BatchProperties batchProperties) {
        Assert.notNull((Object)taskBatchProperties, (String)"taskBatchProperties must not be null");
        Assert.notNull((Object)batchProperties, (String)"batchProperties must not be null");
        Assert.notEmpty(jobs, (String)"jobs must not be null nor empty");
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.jobs = jobs;
        this.jobName = taskBatchProperties.getJobNames();
        this.jobRegistry = jobRegistry;
        this.taskBatchProperties = taskBatchProperties;
        this.jobName = StringUtils.hasText((String)batchProperties.getJob().getName()) ? batchProperties.getJob().getName() : taskBatchProperties.getJobNames();
        this.order = taskBatchProperties.getApplicationRunnerOrder();
        this.jobRepository = jobRepository;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public TaskJobLauncherApplicationRunner getObject() {
        TaskJobLauncherApplicationRunner taskJobLauncherApplicationRunner = new TaskJobLauncherApplicationRunner(this.jobLauncher, this.jobExplorer, this.jobRepository, this.taskBatchProperties);
        taskJobLauncherApplicationRunner.setJobs(this.jobs);
        if (StringUtils.hasText((String)this.jobName)) {
            taskJobLauncherApplicationRunner.setJobName(this.jobName);
        }
        taskJobLauncherApplicationRunner.setJobRegistry(this.jobRegistry);
        if (this.order != null) {
            taskJobLauncherApplicationRunner.setOrder(this.order);
        }
        return taskJobLauncherApplicationRunner;
    }

    public Class<?> getObjectType() {
        return TaskJobLauncherApplicationRunner.class;
    }
}

