/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.launcher;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TaskLaunchRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uri;
    private List<String> commandlineArguments;
    private Map<String, String> environmentProperties;
    private Map<String, String> deploymentProperties;
    private String applicationName;

    public TaskLaunchRequest(String uri, List<String> commandlineArguments, Map<String, String> environmentProperties, Map<String, String> deploymentProperties, String applicationName) {
        Assert.hasText((String)uri, (String)"uri must not be empty nor null.");
        this.uri = uri;
        this.commandlineArguments = commandlineArguments == null ? new ArrayList() : commandlineArguments;
        this.environmentProperties = environmentProperties == null ? new HashMap() : environmentProperties;
        this.deploymentProperties = deploymentProperties == null ? new HashMap() : deploymentProperties;
        this.setApplicationName(applicationName);
    }

    public TaskLaunchRequest() {
    }

    public String getUri() {
        return this.uri;
    }

    public List<String> getCommandlineArguments() {
        return Collections.unmodifiableList(this.commandlineArguments);
    }

    public Map<String, String> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public Map<String, String> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = !StringUtils.hasText((String)applicationName) ? "Task-" + UUID.randomUUID().toString() : applicationName;
    }

    public String toString() {
        return "TaskLaunchRequest{uri='" + this.uri + '\'' + ", commandlineArguments=" + this.commandlineArguments + ", environmentProperties=" + this.environmentProperties + ", deploymentProperties=" + this.deploymentProperties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskLaunchRequest that = (TaskLaunchRequest)o;
        if (!this.uri.equals(that.uri)) {
            return false;
        }
        if (!this.commandlineArguments.equals(that.commandlineArguments)) {
            return false;
        }
        if (!this.deploymentProperties.equals(that.deploymentProperties)) {
            return false;
        }
        return this.environmentProperties.equals(that.environmentProperties);
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = 31 * result + this.commandlineArguments.hashCode();
        result = 31 * result + this.environmentProperties.hashCode();
        result = 31 * result + this.deploymentProperties.hashCode();
        return result;
    }
}

