/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.util.StringUtils;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.support.VaultHealth;

public class VaultHealthIndicator
implements HealthIndicator {
    private final VaultOperations vaultOperations;

    public VaultHealthIndicator(VaultOperations vaultOperations) {
        this.vaultOperations = vaultOperations;
    }

    public Health health() {
        try {
            VaultHealth vaultHealthResponse = this.vaultOperations.opsForSys().health();
            Health.Builder healthBuilder = this.getHealthBuilder(vaultHealthResponse);
            if (StringUtils.hasText((String)vaultHealthResponse.getVersion())) {
                healthBuilder = healthBuilder.withDetail("version", (Object)vaultHealthResponse.getVersion());
            }
            return healthBuilder.build();
        }
        catch (Exception e) {
            return Health.down((Exception)e).build();
        }
    }

    private Health.Builder getHealthBuilder(VaultHealth vaultHealthResponse) {
        if (!vaultHealthResponse.isInitialized()) {
            return Health.down().withDetail("state", (Object)"Vault uninitialized");
        }
        if (vaultHealthResponse.isSealed()) {
            return Health.down().withDetail("state", (Object)"Vault sealed");
        }
        if (vaultHealthResponse.isStandby()) {
            return Health.up().withDetail("state", (Object)"Vault in standby");
        }
        return Health.up();
    }
}

