/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cassandra.core.PrimaryKeyType;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.cassandra.core.cql.generator.TableCqlGenerator;
import org.springframework.cassandra.core.keyspace.ColumnSpecification;
import org.springframework.cassandra.core.keyspace.CreateTableSpecification;

public class CreateTableCqlGenerator
extends TableCqlGenerator<CreateTableSpecification> {
    public static String toCql(CreateTableSpecification specification) {
        return new CreateTableCqlGenerator(specification).toCql();
    }

    public CreateTableCqlGenerator(CreateTableSpecification specification) {
        super(specification);
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        this.preambleCql(cql);
        this.columnsAndOptionsCql(cql);
        cql.append(";");
        return cql;
    }

    protected StringBuilder preambleCql(StringBuilder cql) {
        return CqlStringUtils.noNull(cql).append("CREATE TABLE ").append(((CreateTableSpecification)this.spec()).getIfNotExists() ? "IF NOT EXISTS " : "").append(((CreateTableSpecification)this.spec()).getName());
    }

    protected StringBuilder columnsAndOptionsCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        cql.append(" (");
        ArrayList<ColumnSpecification> partitionKeys = new ArrayList<ColumnSpecification>();
        ArrayList<ColumnSpecification> clusterKeys = new ArrayList<ColumnSpecification>();
        for (ColumnSpecification col : ((CreateTableSpecification)this.spec()).getColumns()) {
            col.toCql(cql).append(", ");
            if (col.getKeyType() == PrimaryKeyType.PARTITIONED) {
                partitionKeys.add(col);
                continue;
            }
            if (col.getKeyType() != PrimaryKeyType.CLUSTERED) continue;
            clusterKeys.add(col);
        }
        cql.append("PRIMARY KEY (");
        if (partitionKeys.size() > 1) {
            cql.append("(");
        }
        CreateTableCqlGenerator.appendColumnNames(cql, partitionKeys);
        if (partitionKeys.size() > 1) {
            cql.append(")");
        }
        if (!clusterKeys.isEmpty()) {
            cql.append(", ");
        }
        CreateTableCqlGenerator.appendColumnNames(cql, clusterKeys);
        cql.append(")");
        cql.append(")");
        StringBuilder ordering = CreateTableCqlGenerator.createOrderingClause(clusterKeys);
        Map<String, Object> options = ((CreateTableSpecification)this.spec()).getOptions();
        if (ordering != null || !options.isEmpty()) {
            boolean first = true;
            cql.append(" WITH ");
            if (ordering != null) {
                cql.append((CharSequence)ordering);
                first = false;
            }
            if (!options.isEmpty()) {
                for (String name : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        cql.append(" AND ");
                    }
                    cql.append(name);
                    Object value = options.get(name);
                    if (value == null) continue;
                    cql.append(" = ");
                    if (value instanceof Map) {
                        this.optionValueMap((Map)value, cql);
                        continue;
                    }
                    cql.append(value.toString());
                }
            }
        }
        return cql;
    }

    private static StringBuilder createOrderingClause(List<ColumnSpecification> columns) {
        StringBuilder ordering = null;
        boolean first = true;
        for (ColumnSpecification col : columns) {
            if (col.getOrdering() == null) continue;
            if (ordering == null) {
                ordering = new StringBuilder().append("CLUSTERING ORDER BY (");
            }
            if (first) {
                first = false;
            } else {
                ordering.append(", ");
            }
            ordering.append(col.getName()).append(" ").append(col.getOrdering().cql());
        }
        if (ordering != null) {
            ordering.append(")");
        }
        return ordering;
    }

    private static void appendColumnNames(StringBuilder str, List<ColumnSpecification> columns) {
        boolean first = true;
        for (ColumnSpecification col : columns) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(col.getName());
        }
    }
}

