/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql.generator;

import java.util.Map;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.cassandra.core.cql.generator.AddColumnCqlGenerator;
import org.springframework.cassandra.core.cql.generator.AlterColumnCqlGenerator;
import org.springframework.cassandra.core.cql.generator.ColumnChangeCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropColumnCqlGenerator;
import org.springframework.cassandra.core.cql.generator.RenameColumnCqlGenerator;
import org.springframework.cassandra.core.cql.generator.TableOptionsCqlGenerator;
import org.springframework.cassandra.core.keyspace.AddColumnSpecification;
import org.springframework.cassandra.core.keyspace.AlterColumnSpecification;
import org.springframework.cassandra.core.keyspace.AlterTableSpecification;
import org.springframework.cassandra.core.keyspace.ColumnChangeSpecification;
import org.springframework.cassandra.core.keyspace.DropColumnSpecification;
import org.springframework.cassandra.core.keyspace.RenameColumnSpecification;
import org.springframework.cassandra.core.keyspace.TableOption;

public class AlterTableCqlGenerator
extends TableOptionsCqlGenerator<AlterTableSpecification> {
    public static String toCql(AlterTableSpecification specification) {
        return new AlterTableCqlGenerator(specification).toCql();
    }

    public AlterTableCqlGenerator(AlterTableSpecification specification) {
        super(specification);
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        this.preambleCql(cql);
        if (!((AlterTableSpecification)this.spec()).getChanges().isEmpty()) {
            cql.append(' ');
            this.changesCql(cql);
        }
        if (!((AlterTableSpecification)this.spec()).getOptions().isEmpty()) {
            cql.append(' ');
            this.optionsCql(cql);
        }
        cql.append(";");
        return cql;
    }

    protected StringBuilder preambleCql(StringBuilder cql) {
        return CqlStringUtils.noNull(cql).append("ALTER TABLE ").append(((AlterTableSpecification)this.spec()).getName());
    }

    protected StringBuilder changesCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        boolean first = true;
        for (ColumnChangeSpecification change : ((AlterTableSpecification)this.spec()).getChanges()) {
            if (first) {
                first = false;
            } else {
                cql.append(" ");
            }
            this.getCqlGeneratorFor(change).toCql(cql);
        }
        return cql;
    }

    protected ColumnChangeCqlGenerator<?> getCqlGeneratorFor(ColumnChangeSpecification change) {
        if (change instanceof AddColumnSpecification) {
            return new AddColumnCqlGenerator((AddColumnSpecification)change);
        }
        if (change instanceof DropColumnSpecification) {
            return new DropColumnCqlGenerator((DropColumnSpecification)change);
        }
        if (change instanceof AlterColumnSpecification) {
            return new AlterColumnCqlGenerator((AlterColumnSpecification)change);
        }
        if (change instanceof RenameColumnSpecification) {
            return new RenameColumnCqlGenerator((RenameColumnSpecification)change);
        }
        throw new IllegalArgumentException("unknown ColumnChangeSpecification type: " + change.getClass().getName());
    }

    protected StringBuilder optionsCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        Map<String, Object> options = ((AlterTableSpecification)this.spec()).getOptions();
        if (options == null || options.isEmpty()) {
            return cql;
        }
        cql.append("WITH ");
        boolean first = true;
        for (String key : options.keySet()) {
            if (key.equals(TableOption.COMPACT_STORAGE.getName())) {
                throw new IllegalArgumentException("Alter table cannot contain the COMPACT STORAGE option");
            }
            if (first) {
                first = false;
            } else {
                cql.append(" AND ");
            }
            cql.append(key);
            Object value = options.get(key);
            if (value == null) continue;
            cql.append(" = ");
            if (value instanceof Map) {
                this.optionValueMap((Map)value, cql);
                continue;
            }
            cql.append(value.toString());
        }
        return cql;
    }
}

