/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cassandra.config.xml.CassandraCqlSessionParser;
import org.springframework.cassandra.config.xml.ParsingUtils;
import org.springframework.data.cassandra.config.CassandraSessionFactoryBean;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.config.xml.CassandraMappingXmlBeanFactoryPostProcessorRegistrar;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class CassandraSessionParser
extends CassandraCqlSessionParser {
    protected Class<?> getBeanClass(Element element) {
        return CassandraSessionFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        CassandraMappingXmlBeanFactoryPostProcessorRegistrar.ensureRegistration(element, parserContext);
    }

    protected void parseUnhandledSessionElementAttribute(Attr attribute, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String name = attribute.getName();
        if ("cassandra-converter-ref".equals(name)) {
            ParsingUtils.addOptionalPropertyReference((BeanDefinitionBuilder)builder, (String)"converter", (Attr)attribute, (String)"cassandraConverter");
        } else if ("schema-action".equals(name)) {
            ParsingUtils.addOptionalPropertyValue((BeanDefinitionBuilder)builder, (String)"schemaAction", (Attr)attribute, (String)SchemaAction.NONE.name());
        } else {
            super.parseUnhandledSessionElementAttribute(attribute, parserContext, builder);
        }
    }

    protected void setDefaultProperties(BeanDefinitionBuilder builder) {
        super.setDefaultProperties(builder);
        ParsingUtils.addRequiredPropertyValue((BeanDefinitionBuilder)builder, (String)"schemaAction", (String)SchemaAction.NONE.name());
        ParsingUtils.addRequiredPropertyReference((BeanDefinitionBuilder)builder, (String)"converter", (String)"cassandraConverter");
    }
}

