/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import com.datastax.driver.core.DataType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

public class CassandraSimpleTypeHolder
extends SimpleTypeHolder {
    public static final Set<Class<?>> CASSANDRA_SIMPLE_TYPES;
    private static final Map<Class<?>, Class<?>> primitiveTypesByWrapperType;
    private static final Map<Class<?>, DataType> dataTypesByJavaClass;
    private static final Map<DataType.Name, DataType> dataTypesByDataTypeName;

    public static DataType getDataTypeFor(DataType.Name name) {
        return dataTypesByDataTypeName.get(name);
    }

    public static DataType getDataTypeFor(Class<?> javaClass) {
        return dataTypesByJavaClass.get(javaClass);
    }

    public static DataType.Name[] getDataTypeNamesFrom(List<TypeInformation<?>> arguments) {
        DataType.Name[] array = new DataType.Name[arguments.size()];
        for (int i = 0; i != array.length; ++i) {
            TypeInformation<?> typeInfo = arguments.get(i);
            DataType dataType = CassandraSimpleTypeHolder.getDataTypeFor(typeInfo.getType());
            if (dataType == null) {
                throw new InvalidDataAccessApiUsageException("not found appropriate primitive DataType for type = '" + typeInfo.getType());
            }
            array[i] = dataType.getName();
        }
        return array;
    }

    public CassandraSimpleTypeHolder() {
        super(CASSANDRA_SIMPLE_TYPES, true);
    }

    static {
        primitiveTypesByWrapperType = new HashMap(8);
        dataTypesByJavaClass = new HashMap();
        dataTypesByDataTypeName = new HashMap<DataType.Name, DataType>();
        primitiveTypesByWrapperType.put(Boolean.class, Boolean.TYPE);
        primitiveTypesByWrapperType.put(Byte.class, Byte.TYPE);
        primitiveTypesByWrapperType.put(Character.class, Character.TYPE);
        primitiveTypesByWrapperType.put(Double.class, Double.TYPE);
        primitiveTypesByWrapperType.put(Float.class, Float.TYPE);
        primitiveTypesByWrapperType.put(Integer.class, Integer.TYPE);
        primitiveTypesByWrapperType.put(Long.class, Long.TYPE);
        primitiveTypesByWrapperType.put(Short.class, Short.TYPE);
        HashSet<Class> simpleTypes = new HashSet<Class>();
        for (DataType dataType : DataType.allPrimitiveTypes()) {
            Class javaClass = dataType.asJavaClass();
            simpleTypes.add(javaClass);
            dataTypesByJavaClass.put(javaClass, dataType);
            Class<?> primitiveJavaClass = primitiveTypesByWrapperType.get(javaClass);
            if (primitiveJavaClass != null) {
                dataTypesByJavaClass.put(primitiveJavaClass, dataType);
            }
            dataTypesByDataTypeName.put(dataType.getName(), dataType);
        }
        dataTypesByJavaClass.put(String.class, DataType.text());
        CASSANDRA_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
    }
}

