/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.UnsupportedCassandraQueryOperatorException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

class CassandraQueryCreator
extends AbstractQueryCreator<Select, Clause> {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraQueryCreator.class);
    private final CassandraParameterAccessor accessor;
    private final CassandraMappingContext context;

    public CassandraQueryCreator(PartTree tree, CassandraParameterAccessor accessor, CassandraMappingContext context) {
        super(tree, (ParameterAccessor)accessor);
        Assert.notNull((Object)context);
        this.accessor = accessor;
        this.context = context;
    }

    protected Clause create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CassandraPersistentProperty property = (CassandraPersistentProperty)path.getLeafProperty();
        Clause criteria = this.from(part, property, null, iterator);
        return criteria;
    }

    protected Clause and(Part part, Clause base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CassandraPersistentProperty property = (CassandraPersistentProperty)path.getLeafProperty();
        return this.from(part, property, null, iterator);
    }

    protected Clause or(Clause base, Clause criteria) {
        throw new InvalidDataAccessApiUsageException(String.format("Cassandra does not support an OR operator!", new Object[0]));
    }

    protected Select complete(Clause criteria, Sort sort) {
        if (criteria == null) {
            return null;
        }
        Select select = QueryBuilder.select().all().from("TODO");
        select.where(criteria);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query " + select.getQueryString());
        }
        return select;
    }

    private Clause from(Part part, CassandraPersistentProperty property, Clause criteria, Iterator<Object> parameters) {
        Part.Type type = part.getType();
        switch (type) {
            default: 
        }
        throw new UnsupportedCassandraQueryOperatorException(String.format("", new Object[0]));
    }

    private boolean isSimpleComparisionPossible(Part part) {
        switch (part.shouldIgnoreCase()) {
            case NEVER: {
                return true;
            }
            case WHEN_POSSIBLE: {
                return part.getProperty().getType() != String.class;
            }
            case ALWAYS: {
                return false;
            }
        }
        return true;
    }

    private <T> T nextAs(Iterator<Object> iterator, Class<T> type) {
        Object parameter = iterator.next();
        if (parameter.getClass().isAssignableFrom(type)) {
            return (T)parameter;
        }
        throw new IllegalArgumentException(String.format("Expected parameter type of %s but got %s!", type, parameter.getClass()));
    }

    private Object[] nextAsArray(Iterator<Object> iterator, CassandraPersistentProperty property) {
        Object next = iterator.next();
        if (next instanceof Collection) {
            return ((Collection)next).toArray();
        }
        if (next.getClass().isArray()) {
            return (Object[])next;
        }
        return new Object[]{next};
    }
}

