/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import java.nio.ByteBuffer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

enum RowReaderPropertyAccessor implements PropertyAccessor
{
    INSTANCE;


    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Row.class};
    }

    public boolean canRead(EvaluationContext context, Object target, String name) {
        return ((Row)target).getColumnDefinitions().contains(name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) {
        Row row = (Row)target;
        if (row.isNull(name)) {
            return TypedValue.NULL;
        }
        DataType columnType = row.getColumnDefinitions().getType(name);
        ByteBuffer bytes = row.getBytes(name);
        Object object = columnType.deserialize(bytes, ProtocolVersion.NEWEST_SUPPORTED);
        return new TypedValue(object);
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) {
        throw new UnsupportedOperationException();
    }
}

