/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;

final class InsertUtil {
    static Insert createInsert(CassandraConverter converter, Object entity) {
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(entity.getClass());
        LinkedHashMap toInsert = new LinkedHashMap();
        converter.write(entity, toInsert, persistentEntity);
        Insert insert = QueryBuilder.insertInto((String)persistentEntity.getTableName().toCql());
        for (Map.Entry entry : toInsert.entrySet()) {
            insert.value((String)entry.getKey(), entry.getValue());
        }
        return insert;
    }

    private InsertUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

