/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import lombok.NonNull;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.ExecutableInsertOperation;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ExecutableInsertOperationSupport
implements ExecutableInsertOperation {
    @NonNull
    private final CassandraTemplate template;

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableInsertSupport<T>(this.template, domainType, InsertOptions.empty(), null);
    }

    public ExecutableInsertOperationSupport(@NonNull CassandraTemplate template) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        this.template = template;
    }

    static class ExecutableInsertSupport<T>
    implements ExecutableInsertOperation.ExecutableInsert<T> {
        @NonNull
        private final CassandraTemplate template;
        @NonNull
        private final Class<T> domainType;
        @NonNull
        private final InsertOptions insertOptions;
        @Nullable
        private final CqlIdentifier tableName;

        @Override
        public ExecutableInsertOperation.InsertWithOptions<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ExecutableInsertSupport<T>(this.template, this.domainType, this.insertOptions, tableName);
        }

        @Override
        public ExecutableInsertOperation.TerminatingInsert<T> withOptions(InsertOptions insertOptions) {
            Assert.notNull((Object)insertOptions, (String)"InsertOptions must not be null");
            return new ExecutableInsertSupport<T>(this.template, this.domainType, insertOptions, this.tableName);
        }

        @Override
        public WriteResult one(T object) {
            Assert.notNull(object, (String)"Object must not be null");
            return this.template.doInsert(object, this.insertOptions, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }

        public ExecutableInsertSupport(@NonNull CassandraTemplate template, @NonNull Class<T> domainType, @NonNull InsertOptions insertOptions, @Nullable CqlIdentifier tableName) {
            if (template == null) {
                throw new NullPointerException("template");
            }
            if (domainType == null) {
                throw new NullPointerException("domainType");
            }
            if (insertOptions == null) {
                throw new NullPointerException("insertOptions");
            }
            this.template = template;
            this.domainType = domainType;
            this.insertOptions = insertOptions;
            this.tableName = tableName;
        }
    }
}

