/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.util.Assert;

class QueryUtils {
    private static final Pattern FROM_REGEX = Pattern.compile(" FROM ([\"]?[\\w]*[\\\\.]?[\\w]*[\"]?)[\\s]?", 2);

    QueryUtils() {
    }

    static Insert createInsertQuery(String tableName, Object objectToUpdate, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        InsertOptions insertOptions;
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull((Object)objectToUpdate, (String)"Object to insert must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Insert insert = QueryOptionsUtil.addWriteOptions(QueryBuilder.insertInto((String)tableName), options);
        if (options instanceof InsertOptions && (insertOptions = (InsertOptions)options).isIfNotExists()) {
            insert = insert.ifNotExists();
        }
        entityWriter.write(objectToUpdate, (Object)insert);
        return insert;
    }

    static Update createUpdateQuery(String tableName, Object objectToUpdate, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        UpdateOptions updateOptions;
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull((Object)objectToUpdate, (String)"Object to update must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Update update = QueryOptionsUtil.addWriteOptions(QueryBuilder.update((String)tableName), options);
        if (options instanceof UpdateOptions && (updateOptions = (UpdateOptions)options).isIfExists()) {
            update.where().ifExists();
        }
        entityWriter.write(objectToUpdate, (Object)update);
        return update;
    }

    static Delete createDeleteQuery(String tableName, Object objectToDelete, QueryOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull((Object)objectToDelete, (String)"Object to delete must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Delete.Selection deleteSelection = QueryBuilder.delete();
        Delete delete = deleteSelection.from(tableName);
        if (options instanceof WriteOptions) {
            QueryOptionsUtil.addWriteOptions(delete, (WriteOptions)options);
        } else {
            QueryOptionsUtil.addQueryOptions(delete, options);
        }
        Delete.Where where = delete.where();
        entityWriter.write(objectToDelete, (Object)where);
        return delete;
    }

    static <T> Slice<T> readSlice(ResultSet resultSet, RowMapper<T> mapper, int page, int pageSize) {
        int toRead = resultSet.getAvailableWithoutFetching();
        ArrayList<T> result = new ArrayList<T>(toRead);
        for (int index = 0; index < toRead; ++index) {
            T element = mapper.mapRow(resultSet.one(), index);
            result.add(element);
        }
        PagingState pagingState = resultSet.getExecutionInfo().getPagingState();
        CassandraPageRequest pageRequest = CassandraPageRequest.of((Pageable)PageRequest.of((int)page, (int)pageSize), pagingState);
        return new SliceImpl(result, (Pageable)pageRequest, pagingState != null);
    }

    static CqlIdentifier getTableName(Statement statement) {
        Select select2;
        DirectFieldAccessor accessor;
        String table;
        if (statement instanceof Select && (table = (String)(accessor = new DirectFieldAccessor((Object)(select2 = (Select)statement))).getPropertyValue("table")) != null) {
            return CqlIdentifier.of(table);
        }
        String cql = statement.toString();
        Matcher matcher = FROM_REGEX.matcher(cql);
        if (matcher.find()) {
            String cqlTableName = matcher.group(1);
            if (cqlTableName.startsWith("\"")) {
                return CqlIdentifier.quoted(cqlTableName.substring(1, cqlTableName.length() - 1));
            }
            int separator = cqlTableName.indexOf(46);
            if (separator != -1) {
                return CqlIdentifier.of(cqlTableName.substring(separator + 1));
            }
            return CqlIdentifier.of(cqlTableName);
        }
        return CqlIdentifier.of("unknown");
    }
}

