/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UserType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.cql.PrimaryKeyType;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.core.mapping.Column;
import org.springframework.data.cassandra.core.mapping.PrimaryKey;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.cassandra.util.SpelUtils;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BasicCassandraPersistentProperty
extends AnnotationBasedPersistentProperty<CassandraPersistentProperty>
implements CassandraPersistentProperty,
ApplicationContextAware {
    private Boolean forceQuote;
    @Nullable
    private CqlIdentifier columnName;
    @Nullable
    private StandardEvaluationContext spelContext;
    @Nullable
    private final UserTypeResolver userTypeResolver;

    public BasicCassandraPersistentProperty(Property property, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        this(property, owner, simpleTypeHolder, null);
    }

    public BasicCassandraPersistentProperty(Property property, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder, @Nullable UserTypeResolver userTypeResolver) {
        super(property, owner, simpleTypeHolder);
        this.userTypeResolver = userTypeResolver;
    }

    public void setApplicationContext(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        this.spelContext = new StandardEvaluationContext();
        this.spelContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.spelContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context));
        this.spelContext.setRootObject((Object)context);
    }

    public CassandraPersistentEntity<?> getOwner() {
        return (CassandraPersistentEntity)super.getOwner();
    }

    @Override
    public CqlIdentifier getColumnName() {
        if (this.columnName == null) {
            this.columnName = this.determineColumnName();
        }
        Assert.state((this.columnName != null ? 1 : 0) != 0, () -> String.format("Cannot determine column name for %s", this));
        return this.columnName;
    }

    @Override
    @Nullable
    public Integer getOrdinal() {
        return null;
    }

    @Override
    @Nullable
    public Ordering getPrimaryKeyOrdering() {
        PrimaryKeyColumn annotation = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return annotation != null ? annotation.ordering() : null;
    }

    @Override
    public DataType getDataType() {
        DataType dataType = this.findDataType();
        if (dataType == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Unknown type [%s] for property [%s] in entity [%s]; only primitive types and Collections or Maps of primitive types are allowed", this.getType(), this.getName(), this.getOwner().getName()));
        }
        return dataType;
    }

    @Nullable
    private DataType findDataType() {
        CassandraType cassandraType = (CassandraType)this.findAnnotation(CassandraType.class);
        if (cassandraType != null) {
            return this.getDataTypeFor(cassandraType);
        }
        if (this.isMap()) {
            List args = this.getTypeInformation().getTypeArguments();
            this.assertTypeArguments(args.size(), 2);
            return DataType.map((DataType)this.getDataTypeFor(((TypeInformation)args.get(0)).getType()), (DataType)this.getDataTypeFor(((TypeInformation)args.get(1)).getType()));
        }
        if (this.isCollectionLike()) {
            List args = this.getTypeInformation().getTypeArguments();
            this.assertTypeArguments(args.size(), 1);
            if (Set.class.isAssignableFrom(this.getType())) {
                return DataType.set((DataType)this.getDataTypeFor(((TypeInformation)args.get(0)).getType()));
            }
            if (List.class.isAssignableFrom(this.getType())) {
                return DataType.list((DataType)this.getDataTypeFor(((TypeInformation)args.get(0)).getType()));
            }
        }
        return CassandraSimpleTypeHolder.getDataTypeFor(this.getType());
    }

    private DataType getDataTypeFor(CassandraType annotation) {
        DataType.Name type = annotation.type();
        switch (type) {
            case MAP: {
                this.assertTypeArguments(annotation.typeArguments().length, 2);
                return DataType.map((DataType)CassandraSimpleTypeHolder.getDataTypeFor(annotation.typeArguments()[0]), (DataType)CassandraSimpleTypeHolder.getDataTypeFor(annotation.typeArguments()[1]));
            }
            case LIST: {
                this.assertTypeArguments(annotation.typeArguments().length, 1);
                return annotation.typeArguments()[0] == DataType.Name.UDT ? DataType.list((DataType)this.getUserType(annotation)) : DataType.list((DataType)CassandraSimpleTypeHolder.getDataTypeFor(annotation.typeArguments()[0]));
            }
            case SET: {
                this.assertTypeArguments(annotation.typeArguments().length, 1);
                return annotation.typeArguments()[0] == DataType.Name.UDT ? DataType.set((DataType)this.getUserType(annotation)) : DataType.set((DataType)CassandraSimpleTypeHolder.getDataTypeFor(annotation.typeArguments()[0]));
            }
            case UDT: {
                return this.getUserType(annotation);
            }
        }
        return CassandraSimpleTypeHolder.getDataTypeFor(type);
    }

    private DataType getUserType(CassandraType annotation) {
        if (!StringUtils.hasText((String)annotation.userTypeName())) {
            throw new InvalidDataAccessApiUsageException(String.format("Expected user type name in property ['%s'] of type ['%s'] in entity [%s]", this.getName(), this.getType(), this.getOwner().getName()));
        }
        Assert.state((this.userTypeResolver != null ? 1 : 0) != 0, (String)"UserTypeResolver is null");
        CqlIdentifier identifier = CqlIdentifier.of(annotation.userTypeName());
        UserType userType = this.userTypeResolver.resolveType(identifier);
        if (userType == null) {
            throw new MappingException(String.format("User type [%s] not found", identifier));
        }
        return userType;
    }

    private DataType getDataTypeFor(Class<?> javaType) {
        DataType dataType = CassandraSimpleTypeHolder.getDataTypeFor(javaType);
        if (dataType == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Only primitive types are allowed inside Collections for property [%1$s] of type ['%2$s'] in entity [%3$s]", this.getName(), this.getType(), this.getOwner().getName()));
        }
        return dataType;
    }

    private void assertTypeArguments(int args, int expected) {
        if (args != expected) {
            throw new InvalidDataAccessApiUsageException(String.format("Expected [%1$s] type arguments for property ['%2$s'] of type ['%3$s'] in entity [%4$s]; actual was [%5$d]", expected, this.getName(), this.getType(), this.getOwner().getName(), args));
        }
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.getType(), PrimaryKeyClass.class) != null;
    }

    @Override
    public boolean isClusterKeyColumn() {
        PrimaryKeyColumn annotation = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return annotation != null && PrimaryKeyType.CLUSTERED.equals((Object)annotation.type());
    }

    @Override
    public boolean isPartitionKeyColumn() {
        PrimaryKeyColumn annotation = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return annotation != null && PrimaryKeyType.PARTITIONED.equals((Object)annotation.type());
    }

    @Override
    public boolean isPrimaryKeyColumn() {
        return this.isAnnotationPresent(PrimaryKeyColumn.class);
    }

    @Nullable
    private CqlIdentifier determineColumnName() {
        if (this.isCompositePrimaryKey()) {
            return null;
        }
        String defaultName = this.getName();
        String overriddenName = null;
        boolean forceQuote = false;
        if (this.isIdProperty()) {
            PrimaryKey primaryKey = (PrimaryKey)this.findAnnotation(PrimaryKey.class);
            if (primaryKey != null) {
                overriddenName = primaryKey.value();
                forceQuote = primaryKey.forceQuote();
            }
        } else if (this.isPrimaryKeyColumn()) {
            PrimaryKeyColumn primaryKeyColumn = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
            if (primaryKeyColumn != null) {
                overriddenName = primaryKeyColumn.value();
                forceQuote = primaryKeyColumn.forceQuote();
            }
        } else {
            Column column = (Column)this.findAnnotation(Column.class);
            if (column != null) {
                overriddenName = column.value();
                forceQuote = column.forceQuote();
            }
        }
        return this.createColumnName(defaultName, overriddenName, forceQuote);
    }

    @Nullable
    private CqlIdentifier createColumnName(String defaultName, @Nullable String overriddenName, boolean forceQuote) {
        String name = defaultName;
        if (StringUtils.hasText((String)overriddenName)) {
            name = this.spelContext != null ? SpelUtils.evaluate(overriddenName, (EvaluationContext)this.spelContext) : overriddenName;
        }
        return name != null ? CqlIdentifier.of(name, forceQuote) : null;
    }

    @Override
    public void setColumnName(CqlIdentifier columnName) {
        Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
        this.columnName = columnName;
    }

    @Override
    public void setForceQuote(boolean forceQuote) {
        boolean changed = !Boolean.valueOf(forceQuote).equals(this.forceQuote);
        this.forceQuote = forceQuote;
        if (changed) {
            this.setColumnName(CqlIdentifier.of(this.getRequiredColumnName().getUnquoted(), forceQuote));
        }
    }

    public Association<CassandraPersistentProperty> getAssociation() {
        return null;
    }

    protected Association<CassandraPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, (PersistentProperty)this);
    }

    @Override
    public boolean isMapLike() {
        return ClassUtils.isAssignable(Map.class, (Class)this.getType());
    }

    @Override
    public AnnotatedType findAnnotatedType(Class<? extends Annotation> annotationType) {
        return Optionals.toStream((Optional[])new Optional[]{Optional.ofNullable(this.getField()).map(Field::getAnnotatedType), Optional.ofNullable(this.getGetter()).map(Method::getAnnotatedReturnType), Optional.ofNullable(this.getSetter()).map(it -> it.getParameters()[0].getAnnotatedType())}).filter(it -> BasicCassandraPersistentProperty.hasAnnotation(it, annotationType, this.getTypeInformation())).findFirst().orElse(null);
    }

    private static boolean hasAnnotation(AnnotatedType type, Class<? extends Annotation> annotationType, TypeInformation<?> typeInformation) {
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)type, annotationType)) {
            return true;
        }
        AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
        AnnotatedType[] arguments = parameterizedType.getAnnotatedActualTypeArguments();
        if (typeInformation.isCollectionLike() && arguments.length == 1) {
            return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)arguments[0], annotationType);
        }
        if (typeInformation.isMap() && arguments.length == 2) {
            return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)arguments[0], annotationType) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)arguments[1], annotationType);
        }
        return false;
    }
}

