/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.Statement;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraRepositoryQuerySupport;
import org.springframework.data.cassandra.repository.query.ConvertingParameterAccessor;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryExecution;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveCassandraQuery
extends CassandraRepositoryQuerySupport {
    private final ReactiveCassandraOperations operations;

    private static CassandraConverter toConverter(ReactiveCassandraOperations operations) {
        Assert.notNull((Object)operations, (String)"ReactiveCassandraOperations must not be null");
        return operations.getConverter();
    }

    private static CassandraMappingContext toMappingContext(ReactiveCassandraOperations operations) {
        return AbstractReactiveCassandraQuery.toConverter(operations).getMappingContext();
    }

    public AbstractReactiveCassandraQuery(ReactiveCassandraQueryMethod method, ReactiveCassandraOperations operations) {
        super(method, (MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)AbstractReactiveCassandraQuery.toMappingContext(operations));
        this.operations = operations;
    }

    protected ReactiveCassandraOperations getReactiveCassandraOperations() {
        return this.operations;
    }

    @Override
    public ReactiveCassandraQueryMethod getQueryMethod() {
        return (ReactiveCassandraQueryMethod)super.getQueryMethod();
    }

    public Object execute(Object[] parameters) {
        return this.getQueryMethod().hasReactiveWrapperParameter() ? this.executeDeferred(parameters) : this.executeNow(parameters);
    }

    private Object executeDeferred(Object[] parameters) {
        return this.getQueryMethod().isCollectionQuery() ? Flux.defer(() -> (Publisher)this.execute(parameters)) : Mono.defer(() -> (Mono)this.execute(parameters));
    }

    private Object executeNow(Object[] parameters) {
        ReactiveCassandraParameterAccessor parameterAccessor = new ReactiveCassandraParameterAccessor(this.getQueryMethod(), parameters);
        ConvertingParameterAccessor convertingParameterAccessor = new ConvertingParameterAccessor(AbstractReactiveCassandraQuery.toConverter(this.getReactiveCassandraOperations()), parameterAccessor);
        Statement statement = this.createQuery(convertingParameterAccessor);
        ResultProcessor resultProcessor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)convertingParameterAccessor);
        ReactiveCassandraQueryExecution queryExecution = this.getExecution(new ReactiveCassandraQueryExecution.ResultProcessingConverter(resultProcessor, (MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)AbstractReactiveCassandraQuery.toMappingContext(this.getReactiveCassandraOperations()), this.getEntityInstantiators()));
        Class<?> resultType = this.resolveResultType(resultProcessor);
        return queryExecution.execute(statement, resultType);
    }

    private Class<?> resolveResultType(ResultProcessor resultProcessor) {
        CassandraRepositoryQuerySupport.CassandraReturnedType returnedType = new CassandraRepositoryQuerySupport.CassandraReturnedType(this, resultProcessor.getReturnedType(), AbstractReactiveCassandraQuery.toConverter(this.getReactiveCassandraOperations()).getCustomConversions());
        return returnedType.isProjecting() ? returnedType.getDomainType() : returnedType.getReturnedType();
    }

    protected abstract Statement createQuery(CassandraParameterAccessor var1);

    private ReactiveCassandraQueryExecution getExecution(Converter<Object, Object> resultProcessing) {
        return new ReactiveCassandraQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(), resultProcessing);
    }

    private ReactiveCassandraQueryExecution getExecutionToWrap() {
        if (this.getQueryMethod().isCollectionQuery()) {
            return new ReactiveCassandraQueryExecution.CollectionExecution(this.getReactiveCassandraOperations());
        }
        if (this.isCountQuery()) {
            return (statement, type) -> new ReactiveCassandraQueryExecution.SingleEntityExecution(this.getReactiveCassandraOperations(), false).execute(statement, Long.class);
        }
        if (this.isExistsQuery()) {
            return new ReactiveCassandraQueryExecution.ExistsExecution(this.getReactiveCassandraOperations());
        }
        return new ReactiveCassandraQueryExecution.SingleEntityExecution(this.getReactiveCassandraOperations(), this.isLimiting());
    }

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isLimiting();
}

