/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.query.Criteria;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.repository.CassandraRepository;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.cassandra.repository.support.InsertUtil;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class SimpleCassandraRepository<T, ID>
implements CassandraRepository<T, ID> {
    private final CassandraEntityInformation<T, ID> entityInformation;
    private final CassandraOperations operations;

    public SimpleCassandraRepository(CassandraEntityInformation<T, ID> metadata, CassandraOperations operations) {
        Assert.notNull(metadata, (String)"CassandraEntityInformation must not be null");
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        this.entityInformation = metadata;
        this.operations = operations;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Insert insert = this.createInsert(entity);
        this.operations.getCqlOperations().execute((Statement)insert);
        return entity;
    }

    @Override
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(entity);
            this.operations.getCqlOperations().execute((Statement)this.createInsert(entity));
        }
        return result;
    }

    protected <S extends T> Insert createInsert(S entity) {
        return InsertUtil.createInsert(this.operations.getConverter(), entity);
    }

    @Override
    public <S extends T> S insert(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        this.operations.insert(entity);
        return entity;
    }

    @Override
    public <S extends T> List<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            this.operations.insert(entity);
            result.add(entity);
        }
        return result;
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        return Optional.ofNullable(this.operations.selectOneById(id, this.entityInformation.getJavaType()));
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        return this.operations.exists(id, this.entityInformation.getJavaType());
    }

    public long count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    @Override
    public List<T> findAll() {
        Select select2 = QueryBuilder.select().all().from(this.entityInformation.getTableName().toCql());
        return this.operations.select((Statement)select2, this.entityInformation.getJavaType());
    }

    @Override
    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of id's must not be null");
        List idCollection = (List)Streamable.of(ids).stream().collect(StreamUtils.toUnmodifiableList());
        return this.operations.select(Query.query(Criteria.where(this.entityInformation.getIdAttribute()).in(idCollection)), this.entityInformation.getJavaType());
    }

    @Override
    public Slice<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        return this.operations.slice(Query.empty().pageRequest(pageable), this.entityInformation.getJavaType());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        this.operations.deleteById(id, this.entityInformation.getJavaType());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        this.deleteById(this.entityInformation.getRequiredId(entity));
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        entities.forEach(this.operations::delete);
    }

    public void deleteAll() {
        this.operations.truncate(this.entityInformation.getJavaType());
    }
}

