/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.AsyncCassandraOperations;
import org.springframework.data.cassandra.core.EntityOperations;
import org.springframework.data.cassandra.core.EntityQueryUtils;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.cql.AsyncCqlOperations;
import org.springframework.data.cassandra.core.cql.AsyncCqlTemplate;
import org.springframework.data.cassandra.core.cql.AsyncSessionCallback;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.GuavaListenableFutureAdapter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureAdapter;

public class AsyncCassandraTemplate
implements AsyncCassandraOperations,
ApplicationEventPublisherAware {
    private final AsyncCqlOperations cqlOperations;
    private final CassandraConverter converter;
    private final CqlExceptionTranslator exceptionTranslator;
    private final EntityOperations entityOperations;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final StatementFactory statementFactory;
    @Nullable
    private ApplicationEventPublisher eventPublisher;

    public AsyncCassandraTemplate(Session session) {
        this(session, (CassandraConverter)AsyncCassandraTemplate.newConverter());
    }

    public AsyncCassandraTemplate(Session session, CassandraConverter converter) {
        this(new DefaultSessionFactory(session), converter);
    }

    public AsyncCassandraTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        this(new AsyncCqlTemplate(sessionFactory), converter);
    }

    public AsyncCassandraTemplate(AsyncCqlTemplate asyncCqlTemplate, CassandraConverter converter) {
        Assert.notNull((Object)asyncCqlTemplate, (String)"AsyncCqlTemplate must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = asyncCqlTemplate;
        this.entityOperations = new EntityOperations((MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)converter.getMappingContext());
        this.exceptionTranslator = asyncCqlTemplate.getExceptionTranslator();
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.statementFactory = new StatementFactory(new QueryMapper(converter), new UpdateMapper(converter));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Override
    public AsyncCqlOperations getAsyncCqlOperations() {
        return this.cqlOperations;
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    protected EntityOperations getEntityOperations() {
        return this.entityOperations;
    }

    protected SpelAwareProxyProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return this.getEntityOperations().getRequiredPersistentEntity(entityType);
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    private CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getEntityOperations().getTableName(entityClass);
    }

    @Override
    public <T> ListenableFuture<List<T>> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.select((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> ListenableFuture<Void> select(String cql, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)new SimpleStatement(cql), entityConsumer, entityClass);
    }

    @Override
    public <T> ListenableFuture<T> selectOne(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> ListenableFuture<List<T>> select(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return this.getAsyncCqlOperations().query(statement, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> ListenableFuture<Void> select(Statement statement, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return this.getAsyncCqlOperations().query(statement, row -> entityConsumer.accept(mapper.apply(row)));
    }

    @Override
    public <T> ListenableFuture<T> selectOne(Statement statement, Class<T> entityClass) {
        return new MappingListenableFutureAdapter<Object, List>(this.select(statement, entityClass), list -> list.stream().findFirst().orElse(null));
    }

    @Override
    public <T> ListenableFuture<Slice<T>> slice(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ListenableFuture<ResultSet> resultSet = this.getAsyncCqlOperations().queryForResultSet(statement);
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return new MappingListenableFutureAdapter<Slice, ResultSet>(resultSet, rs -> EntityQueryUtils.readSlice(rs, (row, rowNum) -> mapper.apply(row), 0, this.getEffectiveFetchSize(statement)));
    }

    @Override
    public <T> ListenableFuture<List<T>> select(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> ListenableFuture<Void> select(Query query2, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)), entityConsumer, entityClass);
    }

    @Override
    public <T> ListenableFuture<T> selectOne(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> ListenableFuture<Slice<T>> slice(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.slice((Statement)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public ListenableFuture<Boolean> update(Query query2, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getAsyncCqlOperations().execute((Statement)this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass)));
    }

    @Override
    public ListenableFuture<Boolean> delete(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doDelete(query2, entityClass, this.getTableName(entityClass));
    }

    private ListenableFuture<Boolean> doDelete(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement delete = this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName));
        ListenableFuture<Boolean> future = this.getAsyncCqlOperations().execute((Statement)this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass)));
        future.addCallback(success -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName)), e -> {});
        return future;
    }

    @Override
    public ListenableFuture<Long> count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Select select2 = QueryBuilder.select().countAll().from(this.getTableName(entityClass).toCql());
        return this.getAsyncCqlOperations().queryForObject((Statement)select2, Long.class);
    }

    @Override
    public ListenableFuture<Long> count(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        RegularStatement count = this.getStatementFactory().count(query2, this.getRequiredPersistentEntity(entityClass));
        ListenableFuture<Long> result = this.getAsyncCqlOperations().queryForObject((Statement)count, Long.class);
        return new MappingListenableFutureAdapter<Long, Long>(result, it -> it != null ? it : 0L);
    }

    @Override
    public ListenableFuture<Boolean> exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        Select select2 = QueryBuilder.select().from(entity.getTableName().toCql());
        this.getConverter().write(id, select2.where(), entity);
        return new MappingListenableFutureAdapter<Boolean, ResultSet>(this.getAsyncCqlOperations().queryForResultSet((Statement)select2), resultSet -> resultSet.iterator().hasNext());
    }

    @Override
    public ListenableFuture<Boolean> exists(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        RegularStatement select2 = this.getStatementFactory().select(query2.limit(1L), this.getRequiredPersistentEntity(entityClass));
        return new MappingListenableFutureAdapter<Boolean, ResultSet>(this.getAsyncCqlOperations().queryForResultSet((Statement)select2), resultSet -> resultSet.iterator().hasNext());
    }

    @Override
    public <T> ListenableFuture<T> selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        Select select2 = QueryBuilder.select().all().from(entity.getTableName().toCql());
        this.getConverter().write(id, select2.where(), entity);
        Function mapper = this.getMapper(entityClass, entityClass, entity.getTableName());
        return new MappingListenableFutureAdapter<Object, List>(this.getAsyncCqlOperations().query((Statement)select2, (row, rowNum) -> mapper.apply(row)), it -> it.isEmpty() ? null : it.get(0));
    }

    @Override
    public <T> ListenableFuture<T> insert(T entity) {
        return new MappingListenableFutureAdapter<Object, EntityWriteResult>(this.insert(entity, InsertOptions.empty()), EntityWriteResult::getEntity);
    }

    @Override
    public <T> ListenableFuture<EntityWriteResult<T>> insert(T entity, InsertOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        T entityToUse = source.isVersionedEntity() ? source.initializeVersionProperty() : entity;
        Insert insert = EntityQueryUtils.createInsertQuery(tableName.toCql(), entityToUse, options, this.getConverter(), persistentEntity);
        return source.isVersionedEntity() ? this.doInsertVersioned(insert.ifNotExists(), entityToUse, source, tableName) : this.doInsert(insert, entityToUse, source, tableName);
    }

    private <T> ListenableFuture<EntityWriteResult<T>> doInsertVersioned(Insert insert, T entity, EntityOperations.AdaptibleEntity<T> source, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, (Statement)insert, result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot insert entity %s with version %s into table %s as it already exists", entity, source.getVersion(), tableName));
            }
        });
    }

    private <T> ListenableFuture<EntityWriteResult<T>> doInsert(Insert insert, T entity, EntityOperations.AdaptibleEntity<T> source, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, (Statement)insert);
    }

    @Override
    public <T> ListenableFuture<T> update(T entity) {
        return new MappingListenableFutureAdapter<Object, EntityWriteResult>(this.update(entity, UpdateOptions.empty()), EntityWriteResult::getEntity);
    }

    @Override
    public <T> ListenableFuture<EntityWriteResult<T>> update(T entity, UpdateOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        return source.isVersionedEntity() ? this.doUpdateVersioned(source, options, tableName, persistentEntity) : this.doUpdate(entity, options, tableName, persistentEntity);
    }

    private <T> ListenableFuture<EntityWriteResult<T>> doUpdateVersioned(EntityOperations.AdaptibleEntity<T> source, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        Number previousVersion = source.getVersion();
        Object entity = source.incrementVersion();
        com.datastax.driver.core.querybuilder.Update update = this.getStatementFactory().update(entity, options, (EntityWriter<Object, Object>)this.getConverter(), persistentEntity, tableName);
        return this.executeSave(entity, tableName, source.appendVersionCondition(update, previousVersion), result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot save entity %s with version %s to table %s. Has it been modified meanwhile?", entity, source.getVersion(), tableName));
            }
        });
    }

    private <T> ListenableFuture<EntityWriteResult<T>> doUpdate(T entity, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        com.datastax.driver.core.querybuilder.Update update = this.getStatementFactory().update(entity, options, (EntityWriter<Object, Object>)this.getConverter(), persistentEntity, tableName);
        return this.executeSave(entity, tableName, (Statement)update);
    }

    @Override
    public <T> ListenableFuture<T> delete(T entity) {
        return new MappingListenableFutureAdapter<Object, WriteResult>(this.delete(entity, QueryOptions.empty()), writeResult -> entity);
    }

    @Override
    public ListenableFuture<WriteResult> delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        EntityOperations.AdaptibleEntity<Object> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        Delete delete = this.getStatementFactory().delete(entity, options, (EntityWriter<Object, Object>)this.getConverter(), persistentEntity, tableName);
        return source.isVersionedEntity() ? this.doDeleteVersioned(delete, entity, source, tableName) : this.doDelete(delete, entity, tableName);
    }

    private ListenableFuture<WriteResult> doDeleteVersioned(Delete delete, Object entity, EntityOperations.AdaptibleEntity<Object> source, CqlIdentifier tableName) {
        return this.executeDelete(entity, tableName, source.appendVersionCondition(delete), result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot delete entity %s with version %s in table %s. Has it been modified meanwhile?", entity, source.getVersion(), tableName));
            }
        });
    }

    private ListenableFuture<WriteResult> doDelete(Delete delete, Object entity, CqlIdentifier tableName) {
        return this.executeDelete(entity, tableName, (Statement)delete, result -> {});
    }

    @Override
    public ListenableFuture<Boolean> deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        Delete delete = QueryBuilder.delete().from(tableName.toCql());
        this.getConverter().write(id, delete.where(), entity);
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName));
        ListenableFuture<Boolean> future = this.getAsyncCqlOperations().execute((Statement)delete);
        future.addCallback(success -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName)), e -> {});
        return future;
    }

    @Override
    public ListenableFuture<Void> truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CqlIdentifier tableName = this.getTableName(entityClass);
        Truncate truncate = QueryBuilder.truncate((String)tableName.toCql());
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)truncate, entityClass, tableName));
        ListenableFuture<Boolean> future = this.getAsyncCqlOperations().execute((Statement)truncate);
        future.addCallback(success -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)truncate, entityClass, tableName)), e -> {});
        return new MappingListenableFutureAdapter<Void, Boolean>(future, aBoolean -> null);
    }

    private <T> ListenableFuture<EntityWriteResult<T>> executeSave(T entity, CqlIdentifier tableName, Statement statement) {
        return this.executeSave(entity, tableName, statement, ignore -> {});
    }

    private <T> ListenableFuture<EntityWriteResult<T>> executeSave(T entity, CqlIdentifier tableName, Statement statement, Consumer<WriteResult> beforeAfterSaveEvent) {
        this.maybeEmitEvent(new BeforeSaveEvent<T>(entity, tableName, statement));
        ListenableFuture<ResultSet> result = this.getAsyncCqlOperations().execute(new AsyncStatementCallback(statement));
        return new MappingListenableFutureAdapter<EntityWriteResult, ResultSet>(result, resultSet -> {
            EntityWriteResult<Object> writeResult = EntityWriteResult.of(resultSet, entity);
            beforeAfterSaveEvent.accept(writeResult);
            this.maybeEmitEvent(new AfterSaveEvent<Object>(entity, tableName));
            return writeResult;
        });
    }

    private ListenableFuture<WriteResult> executeDelete(Object entity, CqlIdentifier tableName, Statement statement, Consumer<WriteResult> resultConsumer) {
        this.maybeEmitEvent(new BeforeDeleteEvent(statement, entity.getClass(), tableName));
        ListenableFuture<ResultSet> result = this.getAsyncCqlOperations().execute(new AsyncStatementCallback(statement));
        return new MappingListenableFutureAdapter<WriteResult, ResultSet>(result, resultSet -> {
            WriteResult writeResult = WriteResult.of(resultSet);
            resultConsumer.accept(writeResult);
            this.maybeEmitEvent(new AfterDeleteEvent(statement, entity.getClass(), tableName));
            return writeResult;
        });
    }

    private int getConfiguredFetchSize(Session session) {
        return session.getCluster().getConfiguration().getQueryOptions().getFetchSize();
    }

    private int getEffectiveFetchSize(Statement statement) {
        CassandraAccessor accessor;
        if (statement.getFetchSize() > 0) {
            return statement.getFetchSize();
        }
        if (this.getAsyncCqlOperations() instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)this.getAsyncCqlOperations())).getFetchSize() != -1) {
            return accessor.getFetchSize();
        }
        return (Integer)this.getAsyncCqlOperations().execute(session -> AsyncResult.forValue((Object)this.getConfiguredFetchSize(session))).completable().join();
    }

    private <T> Function<Row, T> getMapper(Class<?> entityType, Class<T> targetType, CqlIdentifier tableName) {
        Class<?> typeToRead = this.resolveTypeToRead(entityType, targetType);
        return row -> {
            Object result;
            this.maybeEmitEvent(new AfterLoadEvent((Row)row, targetType, tableName));
            Object source = this.getConverter().read(typeToRead, row);
            Object object = result = targetType.isInterface() ? this.getProjectionFactory().createProjection(targetType, source) : source;
            if (result != null) {
                this.maybeEmitEvent(new AfterConvertEvent<Object>((Row)row, result, tableName));
            }
            return result;
        };
    }

    private Class<?> resolveTypeToRead(Class<?> entityType, Class<?> targetType) {
        return targetType.isInterface() || targetType.isAssignableFrom(entityType) ? entityType : targetType;
    }

    private static MappingCassandraConverter newConverter() {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.afterPropertiesSet();
        return converter;
    }

    private void maybeEmitEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    final class AsyncStatementCallback
    implements AsyncSessionCallback<ResultSet>,
    CqlProvider {
        @NonNull
        private final Statement statement;

        AsyncStatementCallback(Statement statement) {
            this.statement = statement;
        }

        @Override
        public ListenableFuture<ResultSet> doInSession(Session session) throws DriverException, DataAccessException {
            return new GuavaListenableFutureAdapter<ResultSet>((com.google.common.util.concurrent.ListenableFuture<ResultSet>)session.executeAsync(this.statement), e -> e instanceof DriverException ? AsyncCassandraTemplate.this.exceptionTranslator.translate("AsyncStatementCallback", this.getCql(), (DriverException)((Object)((Object)e))) : AsyncCassandraTemplate.this.exceptionTranslator.translateExceptionIfPossible(e));
        }

        @Override
        public String getCql() {
            return this.statement.toString();
        }

        @NonNull
        public Statement getStatement() {
            return this.statement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncStatementCallback)) {
                return false;
            }
            AsyncStatementCallback other = (AsyncStatementCallback)o;
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        public String toString() {
            return "AsyncCassandraTemplate.AsyncStatementCallback(statement=" + this.getStatement() + ")";
        }
    }

    static class MappingListenableFutureAdapter<T, S>
    extends ListenableFutureAdapter<T, S> {
        private final Function<S, T> mapper;

        MappingListenableFutureAdapter(ListenableFuture<S> adaptee, Function<S, T> mapper) {
            super(adaptee);
            this.mapper = mapper;
        }

        protected T adapt(@Nullable S adapteeResult) {
            return this.mapper.apply(adapteeResult);
        }
    }
}

