/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.CassandraBatchOperations;
import org.springframework.data.cassandra.core.CassandraBatchTemplate;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.EntityOperations;
import org.springframework.data.cassandra.core.EntityQueryUtils;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.ExecutableDeleteOperation;
import org.springframework.data.cassandra.core.ExecutableDeleteOperationSupport;
import org.springframework.data.cassandra.core.ExecutableInsertOperation;
import org.springframework.data.cassandra.core.ExecutableInsertOperationSupport;
import org.springframework.data.cassandra.core.ExecutableSelectOperation;
import org.springframework.data.cassandra.core.ExecutableSelectOperationSupport;
import org.springframework.data.cassandra.core.ExecutableUpdateOperation;
import org.springframework.data.cassandra.core.ExecutableUpdateOperationSupport;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.CqlTemplate;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.SessionCallback;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraTemplate
implements CassandraOperations,
ApplicationEventPublisherAware {
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    private final CassandraConverter converter;
    private final CqlOperations cqlOperations;
    private final EntityOperations entityOperations;
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final StatementFactory statementFactory;

    public CassandraTemplate(Session session) {
        this(session, (CassandraConverter)CassandraTemplate.newConverter());
    }

    public CassandraTemplate(Session session, CassandraConverter converter) {
        this(new DefaultSessionFactory(session), converter);
    }

    public CassandraTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        this(new CqlTemplate(sessionFactory), converter);
    }

    public CassandraTemplate(CqlOperations cqlOperations, CassandraConverter converter) {
        Assert.notNull((Object)cqlOperations, (String)"CqlOperations must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = cqlOperations;
        this.entityOperations = new EntityOperations((MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)converter.getMappingContext());
        this.mappingContext = converter.getMappingContext();
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.statementFactory = new StatementFactory(new QueryMapper(converter), new UpdateMapper(converter));
    }

    @Override
    public CassandraBatchOperations batchOps() {
        return new CassandraBatchTemplate(this);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    @Override
    public CqlOperations getCqlOperations() {
        return this.cqlOperations;
    }

    protected EntityOperations getEntityOperations() {
        return this.entityOperations;
    }

    protected SpelAwareProxyProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return this.getEntityOperations().getRequiredPersistentEntity(entityType);
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    @Override
    public CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getEntityOperations().getTableName(entityClass);
    }

    @Override
    public <T> List<T> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.select((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> T selectOne(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> Stream<T> stream(String cql, Class<T> entityClass) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.stream((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> List<T> select(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return this.getCqlOperations().query(statement, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> T selectOne(Statement statement, Class<T> entityClass) {
        return this.select(statement, entityClass).stream().findFirst().orElse(null);
    }

    @Override
    public <T> Slice<T> slice(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ResultSet resultSet = this.getCqlOperations().queryForResultSet(statement);
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return EntityQueryUtils.readSlice(resultSet, (row, rowNum) -> mapper.apply(row), 0, this.getEffectiveFetchSize(statement));
    }

    @Override
    public <T> Stream<T> stream(Statement statement, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ResultSet resultSet = this.getCqlOperations().queryForResultSet(statement);
        return StreamSupport.stream(resultSet.spliterator(), false).map(this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement)));
    }

    @Override
    public <T> List<T> select(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doSelect(query2, entityClass, this.getTableName(entityClass), entityClass);
    }

    <T> List<T> doSelect(Query query2, Class<?> entityClass, CqlIdentifier tableName, Class<T> returnType) {
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entityClass);
        Columns columns = this.getStatementFactory().computeColumnsForProjection(query2.getColumns(), persistentEntity, returnType);
        Query queryToUse = query2.columns(columns);
        RegularStatement select2 = this.getStatementFactory().select(queryToUse, persistentEntity, tableName);
        Function mapper = this.getMapper(entityClass, returnType, tableName);
        return this.getCqlOperations().query((Statement)select2, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> T selectOne(Query query2, Class<T> entityClass) throws DataAccessException {
        List<T> result = this.select(query2, entityClass);
        return result.isEmpty() ? null : (T)result.get(0);
    }

    @Override
    public <T> Slice<T> slice(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        RegularStatement select2 = this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass));
        return this.slice((Statement)select2, entityClass);
    }

    @Override
    public <T> Stream<T> stream(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doStream(query2, entityClass, this.getTableName(entityClass), entityClass);
    }

    <T> Stream<T> doStream(Query query2, Class<?> entityClass, CqlIdentifier tableName, Class<T> returnType) {
        RegularStatement statement = this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        ResultSet resultSet = this.getCqlOperations().queryForResultSet((Statement)statement);
        return StreamSupport.stream(resultSet.spliterator(), false).map(this.getMapper(entityClass, returnType, tableName));
    }

    @Override
    public boolean update(Query query2, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        RegularStatement updateStatement = this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass));
        return this.getCqlOperations().execute((Statement)updateStatement);
    }

    @Nullable
    WriteResult doUpdate(Query query2, Update update, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement updateStatement = this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass), tableName);
        return this.getCqlOperations().execute(new StatementCallback((Statement)updateStatement));
    }

    @Override
    public boolean delete(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        WriteResult result = this.doDelete(query2, entityClass, this.getTableName(entityClass));
        return result != null && result.wasApplied();
    }

    @Nullable
    WriteResult doDelete(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement delete = this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName));
        WriteResult writeResult = this.getCqlOperations().execute(new StatementCallback((Statement)delete));
        this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName));
        return writeResult;
    }

    @Override
    public long count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Select select2 = QueryBuilder.select().countAll().from(this.getTableName(entityClass).toCql());
        Long count = this.getCqlOperations().queryForObject((Statement)select2, Long.class);
        return count != null ? count : 0L;
    }

    @Override
    public long count(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doCount(query2, entityClass, this.getTableName(entityClass));
    }

    long doCount(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement countStatement = this.getStatementFactory().count(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        Long count = this.getCqlOperations().queryForObject((Statement)countStatement, Long.class);
        return count != null ? count : 0L;
    }

    @Override
    public boolean exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        Select select2 = QueryBuilder.select().from(this.getTableName(entityClass).toCql());
        this.getConverter().write(id, select2.where(), entity);
        return this.getCqlOperations().queryForResultSet((Statement)select2).iterator().hasNext();
    }

    @Override
    public boolean exists(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doExists(query2, entityClass, this.getTableName(entityClass));
    }

    boolean doExists(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement select2 = this.getStatementFactory().select(query2.limit(1L), this.getRequiredPersistentEntity(entityClass), tableName);
        return this.getCqlOperations().queryForResultSet((Statement)select2).iterator().hasNext();
    }

    @Override
    public <T> T selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CqlIdentifier tableName = this.getTableName(entityClass);
        Select select2 = QueryBuilder.select().all().from(tableName.toCql());
        this.getConverter().write(id, select2.where(), this.getRequiredPersistentEntity(entityClass));
        Function mapper = this.getMapper(entityClass, entityClass, tableName);
        List<Object> result = this.getCqlOperations().query((Statement)select2, (row, rowNum) -> mapper.apply(row));
        return (T)(result.isEmpty() ? null : result.get(0));
    }

    @Override
    public <T> T insert(T entity) {
        return this.insert(entity, InsertOptions.empty()).getEntity();
    }

    @Override
    public <T> EntityWriteResult<T> insert(T entity, InsertOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        return this.doInsert(entity, options, this.getTableName(entity.getClass()));
    }

    <T> EntityWriteResult<T> doInsert(T entity, WriteOptions options, CqlIdentifier tableName) {
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        T entityToUse = source.isVersionedEntity() ? source.initializeVersionProperty() : entity;
        Insert insert = EntityQueryUtils.createInsertQuery(tableName.toCql(), entityToUse, options, this.getConverter(), persistentEntity);
        return source.isVersionedEntity() ? this.doInsertVersioned(insert.ifNotExists(), entityToUse, source, tableName) : this.doInsert(insert, entityToUse, tableName);
    }

    private <T> EntityWriteResult<T> doInsertVersioned(Insert insert, T entity, EntityOperations.AdaptibleEntity<T> source, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, (Statement)insert, result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot insert entity %s with version %s into table %s as it already exists", entity, source.getVersion(), tableName));
            }
        });
    }

    private <T> EntityWriteResult<T> doInsert(Insert insert, T entity, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, (Statement)insert);
    }

    @Override
    public <T> T update(T entity) {
        return this.update(entity, UpdateOptions.empty()).getEntity();
    }

    @Override
    public <T> EntityWriteResult<T> update(T entity, UpdateOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        return source.isVersionedEntity() ? this.doUpdateVersioned(source, options, tableName, persistentEntity) : this.doUpdate(entity, options, tableName, persistentEntity);
    }

    private <T> EntityWriteResult<T> doUpdateVersioned(EntityOperations.AdaptibleEntity<T> source, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        Number previousVersion = source.getVersion();
        Object entity = source.incrementVersion();
        com.datastax.driver.core.querybuilder.Update update = this.getStatementFactory().update(entity, options, (EntityWriter<Object, Object>)this.getConverter(), persistentEntity, tableName);
        return this.executeSave(entity, tableName, source.appendVersionCondition(update, previousVersion), result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot save entity %s with version %s to table %s. Has it been modified meanwhile?", entity, source.getVersion(), tableName));
            }
        });
    }

    private <T> EntityWriteResult<T> doUpdate(T entity, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        com.datastax.driver.core.querybuilder.Update update = this.getStatementFactory().update(entity, options, (EntityWriter<Object, Object>)this.getConverter(), persistentEntity, tableName);
        return this.executeSave(entity, tableName, (Statement)update);
    }

    @Override
    public void delete(Object entity) {
        this.delete(entity, QueryOptions.empty());
    }

    @Override
    public WriteResult delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        EntityOperations.AdaptibleEntity<Object> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        Delete delete = this.getStatementFactory().delete(entity, options, (EntityWriter<Object, Object>)this.getConverter(), persistentEntity, tableName);
        return source.isVersionedEntity() ? this.doDeleteVersioned(delete, entity, source, tableName) : this.doDelete(delete, entity, tableName);
    }

    private WriteResult doDeleteVersioned(Delete delete, Object entity, EntityOperations.AdaptibleEntity<Object> source, CqlIdentifier tableName) {
        return this.executeDelete(entity, tableName, source.appendVersionCondition(delete), result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot delete entity %s with version %s in table %s. Has it been modified meanwhile?", entity, source.getVersion(), tableName));
            }
        });
    }

    private WriteResult doDelete(Delete delete, Object entity, CqlIdentifier tableName) {
        return this.executeDelete(entity, tableName, (Statement)delete, result -> {});
    }

    @Override
    public boolean deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        Delete delete = QueryBuilder.delete().from(tableName.toCql());
        this.getConverter().write(id, delete.where(), entity);
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName));
        boolean result = this.getCqlOperations().execute((Statement)delete);
        this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName));
        return result;
    }

    @Override
    public void truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CqlIdentifier tableName = this.getTableName(entityClass);
        Truncate truncate = QueryBuilder.truncate((String)tableName.toCql());
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)truncate, entityClass, tableName));
        this.getCqlOperations().execute((Statement)truncate);
        this.maybeEmitEvent(new AfterDeleteEvent((Statement)truncate, entityClass, tableName));
    }

    @Override
    public <T> ExecutableSelectOperation.ExecutableSelect<T> query(Class<T> domainType) {
        return new ExecutableSelectOperationSupport(this).query(domainType);
    }

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        return new ExecutableInsertOperationSupport(this).insert(domainType);
    }

    @Override
    public ExecutableUpdateOperation.ExecutableUpdate update(Class<?> domainType) {
        return new ExecutableUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public ExecutableDeleteOperation.ExecutableDelete delete(Class<?> domainType) {
        return new ExecutableDeleteOperationSupport(this).delete(domainType);
    }

    private <T> EntityWriteResult<T> executeSave(T entity, CqlIdentifier tableName, Statement statement) {
        return this.executeSave(entity, tableName, statement, ignore -> {});
    }

    private <T> EntityWriteResult<T> executeSave(T entity, CqlIdentifier tableName, Statement statement, Consumer<WriteResult> resultConsumer) {
        this.maybeEmitEvent(new BeforeSaveEvent<T>(entity, tableName, statement));
        WriteResult result = this.getCqlOperations().execute(new StatementCallback(statement));
        resultConsumer.accept(result);
        this.maybeEmitEvent(new AfterSaveEvent<T>(entity, tableName));
        return EntityWriteResult.of(result, entity);
    }

    private WriteResult executeDelete(Object entity, CqlIdentifier tableName, Statement statement, Consumer<WriteResult> resultConsumer) {
        this.maybeEmitEvent(new BeforeDeleteEvent(statement, entity.getClass(), tableName));
        WriteResult result = this.getCqlOperations().execute(new StatementCallback(statement));
        resultConsumer.accept(result);
        this.maybeEmitEvent(new AfterDeleteEvent(statement, entity.getClass(), tableName));
        return result;
    }

    private int getConfiguredFetchSize(Session session) {
        return session.getCluster().getConfiguration().getQueryOptions().getFetchSize();
    }

    private int getEffectiveFetchSize(Statement statement) {
        CassandraAccessor accessor;
        if (statement.getFetchSize() > 0) {
            return statement.getFetchSize();
        }
        if (this.getCqlOperations() instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)this.getCqlOperations())).getFetchSize() != -1) {
            return accessor.getFetchSize();
        }
        return this.getCqlOperations().execute(this::getConfiguredFetchSize);
    }

    private <T> Function<Row, T> getMapper(Class<?> entityType, Class<T> targetType, CqlIdentifier tableName) {
        Class<?> typeToRead = this.resolveTypeToRead(entityType, targetType);
        return row -> {
            this.maybeEmitEvent(new AfterLoadEvent((Row)row, targetType, tableName));
            Object source = this.getConverter().read(typeToRead, row);
            Object result = targetType.isInterface() ? this.getProjectionFactory().createProjection(targetType, source) : source;
            this.maybeEmitEvent(new AfterConvertEvent<Object>((Row)row, result, tableName));
            return result;
        };
    }

    private Class<?> resolveTypeToRead(Class<?> entityType, Class<?> targetType) {
        return targetType.isInterface() || targetType.isAssignableFrom(entityType) ? entityType : targetType;
    }

    private static MappingCassandraConverter newConverter() {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.afterPropertiesSet();
        return converter;
    }

    private void maybeEmitEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    static final class StatementCallback
    implements SessionCallback<WriteResult>,
    CqlProvider {
        @NonNull
        private final Statement statement;

        @Override
        public WriteResult doInSession(Session session) throws DriverException, DataAccessException {
            return WriteResult.of(session.execute(this.statement));
        }

        @Override
        public String getCql() {
            return this.statement.toString();
        }

        public StatementCallback(@NonNull Statement statement) {
            if (statement == null) {
                throw new NullPointerException("statement is marked @NonNull but is null");
            }
            this.statement = statement;
        }

        @NonNull
        public Statement getStatement() {
            return this.statement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementCallback)) {
                return false;
            }
            StatementCallback other = (StatementCallback)o;
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        public String toString() {
            return "CassandraTemplate.StatementCallback(statement=" + this.getStatement() + ")";
        }
    }
}

