/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import org.springframework.data.cassandra.core.cql.keyspace.CqlStringUtils;
import org.springframework.data.cassandra.core.cql.keyspace.Option;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultOption
implements Option {
    private final String name;
    private final Class<?> type;
    private final boolean requiresValue;
    private final boolean escapesValue;
    private final boolean quotesValue;

    public DefaultOption(String name, Class<?> type, boolean requiresValue, boolean escapesValue, boolean quotesValue) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        Assert.notNull(type, (String)"Type must not be null");
        if (type.isInterface() && !Map.class.isAssignableFrom(type) && !Collection.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("given type [" + type.getName() + "] must be a class, Map or Collection");
        }
        this.name = name;
        this.type = type;
        this.requiresValue = requiresValue;
        this.escapesValue = escapesValue;
        this.quotesValue = quotesValue;
    }

    @Override
    public boolean isCoerceable(Object value) {
        if (this.getType().equals(Void.class)) {
            return true;
        }
        if (Map.class.isAssignableFrom(this.type)) {
            return Map.class.isAssignableFrom(value.getClass());
        }
        if (Collection.class.isAssignableFrom(this.type)) {
            return Collection.class.isAssignableFrom(value.getClass());
        }
        if (this.type.isEnum()) {
            try {
                String name;
                name = value instanceof Enum ? (name = ((Enum)value).name()) : value.toString();
                Enum.valueOf(this.type, name);
                return true;
            }
            catch (IllegalArgumentException | NullPointerException x) {
                return false;
            }
        }
        try {
            Constructor<?> ctor = this.type.getConstructor(String.class);
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
            }
            ctor.newInstance(value.toString());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean takesValue() {
        return this.type != Void.class;
    }

    @Override
    public boolean requiresValue() {
        return this.requiresValue;
    }

    @Override
    public boolean escapesValue() {
        return this.escapesValue;
    }

    @Override
    public boolean quotesValue() {
        return this.quotesValue;
    }

    @Override
    public void checkValue(@Nullable Object value) {
        if (this.takesValue()) {
            if (value == null) {
                if (this.requiresValue) {
                    throw new IllegalArgumentException("Option [" + this.getName() + "] requires a value");
                }
                return;
            }
            if (this.isCoerceable(value)) {
                return;
            }
            throw new IllegalArgumentException("Option [" + this.getName() + "] takes value coerceable to type [" + this.getType() + "]");
        }
        if (value != null) {
            throw new IllegalArgumentException("Option [" + this.getName() + "] takes no value");
        }
    }

    @Override
    public String toString(@Nullable Object value) {
        if (value == null) {
            return "";
        }
        this.checkValue(value);
        String string = value.toString();
        string = this.escapesValue ? CqlStringUtils.escapeSingle(string) : string;
        string = this.quotesValue ? CqlStringUtils.singleQuote(string) : string;
        return string;
    }

    public String toString() {
        return "[name=" + this.name + ", type=" + this.type.getName() + ", requiresValue=" + this.requiresValue + ", escapesValue=" + this.escapesValue + ", quotesValue=" + this.quotesValue + "]";
    }
}

