/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentTupleEntity;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentTupleProperty;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.core.mapping.CassandraUserTypePersistentEntity;
import org.springframework.data.cassandra.core.mapping.CompositeCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.EntityMapping;
import org.springframework.data.cassandra.core.mapping.IdentifierFactory;
import org.springframework.data.cassandra.core.mapping.Mapping;
import org.springframework.data.cassandra.core.mapping.NamingStrategy;
import org.springframework.data.cassandra.core.mapping.PropertyMapping;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.data.cassandra.core.mapping.Tuple;
import org.springframework.data.cassandra.core.mapping.TupleTypeFactory;
import org.springframework.data.cassandra.core.mapping.UserDefinedType;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraMappingContext
extends AbstractMappingContext<BasicCassandraPersistentEntity<?>, CassandraPersistentProperty>
implements ApplicationContextAware,
BeanClassLoaderAware {
    @Nullable
    private ApplicationContext applicationContext;
    private CassandraPersistentEntityMetadataVerifier verifier = new CompositeCassandraPersistentEntityMetadataVerifier();
    @Nullable
    private ClassLoader beanClassLoader;
    @Deprecated
    private CustomConversions customConversions = new CassandraCustomConversions(Collections.emptyList());
    private Mapping mapping = new Mapping();
    private NamingStrategy namingStrategy = NamingStrategy.INSTANCE;
    @Deprecated
    @Nullable
    private UserTypeResolver userTypeResolver;
    @Deprecated
    private CodecRegistry codecRegistry = CodecRegistry.DEFAULT;
    private final Map<CqlIdentifier, Set<CassandraPersistentEntity<?>>> entitySetsByTableName = new ConcurrentHashMap();
    private final Set<BasicCassandraPersistentEntity<?>> tableEntities = ConcurrentHashMap.newKeySet();
    private final Set<BasicCassandraPersistentEntity<?>> userDefinedTypes = ConcurrentHashMap.newKeySet();

    public CassandraMappingContext() {
        this.setSimpleTypeHolder(this.customConversions.getSimpleTypeHolder());
    }

    @Deprecated
    public CassandraMappingContext(UserTypeResolver userTypeResolver, TupleTypeFactory tupleTypeFactory) {
        this.setUserTypeResolver(userTypeResolver);
        this.setTupleTypeFactory(tupleTypeFactory);
        this.setSimpleTypeHolder(this.customConversions.getSimpleTypeHolder());
    }

    public void initialize() {
        super.initialize();
        this.processMappingOverrides();
    }

    private void processMappingOverrides() {
        this.mapping.getEntityMappings().stream().filter(Objects::nonNull).forEach(entityMapping -> {
            Class<?> entityClass = this.getEntityClass(entityMapping.getEntityClassName());
            CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getRequiredPersistentEntity(entityClass);
            String entityTableName = entityMapping.getTableName();
            if (StringUtils.hasText((String)entityTableName)) {
                entity.setTableName(IdentifierFactory.create(entityTableName, Boolean.valueOf(entityMapping.getForceQuote())));
            }
            CassandraMappingContext.processMappingOverrides(entity, entityMapping);
        });
    }

    private Class<?> getEntityClass(String entityClassName) {
        try {
            return ClassUtils.forName((String)entityClassName, (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException cause) {
            throw new IllegalStateException(String.format("Unknown persistent entity type name [%s]", entityClassName), cause);
        }
    }

    private static void processMappingOverrides(CassandraPersistentEntity<?> entity, EntityMapping entityMapping) {
        entityMapping.getPropertyMappings().forEach((key, propertyMapping) -> CassandraMappingContext.processMappingOverride(entity, propertyMapping));
    }

    private static void processMappingOverride(CassandraPersistentEntity<?> entity, PropertyMapping mapping) {
        CassandraPersistentProperty property = (CassandraPersistentProperty)entity.getRequiredPersistentProperty(mapping.getPropertyName());
        boolean forceQuote = Boolean.parseBoolean(mapping.getForceQuote());
        property.setForceQuote(forceQuote);
        if (StringUtils.hasText((String)mapping.getColumnName())) {
            property.setColumnName(IdentifierFactory.create(mapping.getColumnName(), forceQuote));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Deprecated
    public void setCustomConversions(CustomConversions customConversions) {
        Assert.notNull((Object)customConversions, (String)"CustomConversions must not be null");
        this.customConversions = customConversions;
    }

    @Deprecated
    public CustomConversions getCustomConversions() {
        return this.customConversions;
    }

    public void setMapping(Mapping mapping) {
        Assert.notNull((Object)mapping, (String)"Mapping must not be null");
        this.mapping = mapping;
    }

    public Collection<BasicCassandraPersistentEntity<?>> getTableEntities() {
        return Collections.unmodifiableCollection(this.tableEntities);
    }

    public Collection<CassandraPersistentEntity<?>> getUserDefinedTypeEntities() {
        return Collections.unmodifiableSet(this.userDefinedTypes);
    }

    @Deprecated
    public void setCodecRegistry(CodecRegistry codecRegistry) {
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        this.codecRegistry = codecRegistry;
    }

    @Deprecated
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        Assert.notNull((Object)namingStrategy, (String)"NamingStrategy must not be null");
        this.namingStrategy = namingStrategy;
    }

    @Deprecated
    public void setTupleTypeFactory(TupleTypeFactory tupleTypeFactory) {
    }

    @Deprecated
    public void setUserTypeResolver(UserTypeResolver userTypeResolver) {
        Assert.notNull((Object)userTypeResolver, (String)"UserTypeResolver must not be null");
        this.userTypeResolver = userTypeResolver;
    }

    @Nullable
    @Deprecated
    public UserTypeResolver getUserTypeResolver() {
        return this.userTypeResolver;
    }

    public void setVerifier(CassandraPersistentEntityMetadataVerifier verifier) {
        this.verifier = verifier;
    }

    public CassandraPersistentEntityMetadataVerifier getVerifier() {
        return this.verifier;
    }

    protected Optional<BasicCassandraPersistentEntity<?>> addPersistentEntity(TypeInformation<?> typeInformation) {
        Optional optional = this.shouldCreatePersistentEntityFor(typeInformation) ? super.addPersistentEntity(typeInformation) : Optional.empty();
        optional.ifPresent(entity -> {
            if (entity.isUserDefinedType()) {
                this.userDefinedTypes.add((BasicCassandraPersistentEntity<?>)entity);
            }
            Set entities = this.entitySetsByTableName.computeIfAbsent(entity.getTableName(), cqlIdentifier -> ConcurrentHashMap.newKeySet());
            entities.add(entity);
            if (!entity.isUserDefinedType() && !entity.isTupleType() && entity.isAnnotationPresent(Table.class)) {
                this.tableEntities.add((BasicCassandraPersistentEntity<?>)entity);
            }
        });
        return optional;
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> typeInfo) {
        return !this.customConversions.hasCustomWriteTarget(typeInfo.getType()) && super.shouldCreatePersistentEntityFor(typeInfo);
    }

    protected <T> BasicCassandraPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        BasicCassandraPersistentEntity entity = this.isUserDefinedType(typeInformation) ? new CassandraUserTypePersistentEntity<T>(typeInformation, this.getVerifier()) : (this.isTuple(typeInformation) ? new BasicCassandraPersistentTupleEntity<T>(typeInformation) : new BasicCassandraPersistentEntity<T>(typeInformation, this.getVerifier()));
        entity.setNamingStrategy(this.namingStrategy);
        Optional.ofNullable(this.applicationContext).ifPresent(entity::setApplicationContext);
        return entity;
    }

    private boolean isTuple(TypeInformation<?> typeInformation) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)typeInformation.getType(), Tuple.class);
    }

    private boolean isUserDefinedType(TypeInformation<?> typeInformation) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)typeInformation.getType(), UserDefinedType.class);
    }

    protected CassandraPersistentProperty createPersistentProperty(Property property, BasicCassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        BasicCassandraPersistentProperty persistentProperty = owner.isTupleType() ? new BasicCassandraPersistentTupleProperty(property, owner, simpleTypeHolder) : new BasicCassandraPersistentProperty(property, owner, simpleTypeHolder);
        persistentProperty.setNamingStrategy(this.namingStrategy);
        Optional.ofNullable(this.applicationContext).ifPresent(persistentProperty::setApplicationContext);
        return persistentProperty;
    }

    public boolean usesTable(CqlIdentifier name) {
        Assert.notNull((Object)name, (String)"Table name must not be null");
        return this.entitySetsByTableName.containsKey(name);
    }

    public boolean usesUserType(CqlIdentifier name) {
        Assert.notNull((Object)name, (String)"User type name must not be null");
        return this.hasMappedUserType(name) || this.hasReferencedUserType(name);
    }

    private boolean hasMappedUserType(CqlIdentifier identifier) {
        return this.userDefinedTypes.stream().map(CassandraPersistentEntity::getTableName).anyMatch(arg_0 -> ((CqlIdentifier)identifier).equals(arg_0));
    }

    private boolean hasReferencedUserType(CqlIdentifier identifier) {
        return this.getPersistentEntities().stream().flatMap(entity -> StreamSupport.stream(entity.spliterator(), false)).flatMap(it -> Optionals.toStream((Optional[])new Optional[]{Optional.ofNullable(it.findAnnotation(CassandraType.class))})).map(CassandraType::userTypeName).filter(StringUtils::hasText).map(CqlIdentifier::fromCql).anyMatch(arg_0 -> ((CqlIdentifier)identifier).equals(arg_0));
    }
}

