/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.CassandraParametersParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

class ReactiveCassandraParameterAccessor
extends CassandraParametersParameterAccessor {
    private final Object[] values;
    private final List<MonoProcessor<?>> subscriptions;

    ReactiveCassandraParameterAccessor(CassandraQueryMethod method, Object[] values) {
        super(method, values);
        this.values = values;
        this.subscriptions = new ArrayList(values.length);
        for (Object value : values) {
            if (value == null || !ReactiveWrappers.supports(value.getClass())) {
                this.subscriptions.add(null);
                continue;
            }
            if (ReactiveWrappers.isSingleValueType(value.getClass())) {
                this.subscriptions.add(((Mono)ReactiveWrapperConverters.toWrapper((Object)value, Mono.class)).toProcessor());
                continue;
            }
            this.subscriptions.add(((Flux)ReactiveWrapperConverters.toWrapper((Object)value, Flux.class)).collectList().toProcessor());
        }
    }

    protected <T> T getValue(int index) {
        return (T)(this.subscriptions.get(index) != null ? this.subscriptions.get(index).block() : super.getValue(index));
    }

    @Override
    public Object[] getValues() {
        Object[] result = new Object[this.values.length];
        for (int index = 0; index < result.length; ++index) {
            result[index] = this.getValue(index);
        }
        return result;
    }

    public Object getBindableValue(int index) {
        return this.getValue(((CassandraParameters.CassandraParameter)this.getParameters().getBindableParameter(index)).getIndex());
    }
}

