/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.cassandra.config.CassandraTemplateFactoryBean;
import org.springframework.data.cassandra.config.ParsingUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class CassandraTemplateParser
extends AbstractSingleBeanDefinitionParser {
    CassandraTemplateParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return CassandraTemplateFactoryBean.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraTemplate";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        if (element.hasAttribute("cql-template-ref")) {
            ParsingUtils.addRequiredPropertyReference(builder, "cqlOperations", element, "cql-template-ref");
        } else if (element.hasAttribute("session-factory-ref")) {
            ParsingUtils.addRequiredPropertyReference(builder, "sessionFactory", element, "session-factory-ref");
        } else {
            ParsingUtils.addOptionalPropertyReference(builder, "session", element, "session-ref", "cassandraSession");
        }
        if (element.hasAttribute("cassandra-converter-ref")) {
            ParsingUtils.addRequiredPropertyReference(builder, "converter", element, "cassandra-converter-ref");
        }
        builder.getRawBeanDefinition().setSource((Object)element);
    }
}

