/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.support.AnnotationAttribute;
import org.springframework.data.repository.support.MethodParameters;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class ReflectionRepositoryInvoker
implements RepositoryInvoker {
    private static final AnnotationAttribute PARAM_ANNOTATION = new AnnotationAttribute(Param.class);
    private final Object repository;
    private final CrudMethods methods;
    private final Class<? extends Serializable> idType;
    private final ConversionService conversionService;

    public ReflectionRepositoryInvoker(Object repository, RepositoryMetadata metadata, ConversionService conversionService) {
        Assert.notNull((Object)repository, (String)"Repository must not be null!");
        Assert.notNull((Object)metadata, (String)"RepositoryMetadata must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        this.repository = repository;
        this.methods = metadata.getCrudMethods();
        this.idType = metadata.getIdType();
        this.conversionService = conversionService;
    }

    @Override
    public boolean hasFindAllMethod() {
        return this.methods.hasFindAllMethod();
    }

    @Override
    public Iterable<Object> invokeFindAll(Sort sort) {
        return this.invokeFindAllReflectively(sort);
    }

    @Override
    public Iterable<Object> invokeFindAll(Pageable pageable) {
        return this.invokeFindAllReflectively(pageable);
    }

    @Override
    public boolean hasSaveMethod() {
        return this.methods.hasSaveMethod();
    }

    @Override
    public <T> T invokeSave(T object) {
        Assert.state((boolean)this.hasSaveMethod(), (String)"Repository doesn't have a save-method declared!");
        return this.invoke(this.methods.getSaveMethod(), object);
    }

    @Override
    public boolean hasFindOneMethod() {
        return this.methods.hasFindOneMethod();
    }

    @Override
    public <T> T invokeFindOne(Serializable id) {
        Assert.state((boolean)this.hasFindOneMethod(), (String)"Repository doesn't have a find-one-method declared!");
        return this.invoke(this.methods.getFindOneMethod(), this.convertId(id));
    }

    @Override
    public boolean hasDeleteMethod() {
        return this.methods.hasDelete();
    }

    @Override
    public void invokeDelete(Serializable id) {
        Assert.notNull((Object)id, (String)"Identifier must not be null!");
        Assert.state((boolean)this.hasDeleteMethod(), (String)"Repository doesn't have a delete-method declared!");
        Method method = this.methods.getDeleteMethod();
        Class<?> parameterType = method.getParameterTypes()[0];
        List<Class> idTypes = Arrays.asList(this.idType, Serializable.class);
        if (idTypes.contains(parameterType)) {
            this.invoke(method, this.convertId(id));
        } else {
            this.invoke(method, this.invokeFindOne(id));
        }
    }

    @Override
    public Object invokeQueryMethod(Method method, Map<String, String[]> parameters, Pageable pageable, Sort sort) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        return this.invoke(method, this.prepareParameters(method, parameters, pageable, sort));
    }

    private Object[] prepareParameters(Method method, Map<String, String[]> rawParameters, Pageable pageable, Sort sort) {
        List<MethodParameter> parameters = new MethodParameters(method, PARAM_ANNOTATION).getParameters();
        if (parameters.isEmpty()) {
            return new Object[0];
        }
        Object[] result = new Object[parameters.size()];
        Sort sortToUse = pageable == null ? sort : pageable.getSort();
        for (int i = 0; i < result.length; ++i) {
            MethodParameter param = parameters.get(i);
            Class targetType = param.getParameterType();
            if (Pageable.class.isAssignableFrom(targetType)) {
                result[i] = pageable;
                continue;
            }
            if (Sort.class.isAssignableFrom(targetType)) {
                result[i] = sortToUse;
                continue;
            }
            String parameterName = param.getParameterName();
            if (!StringUtils.hasText((String)parameterName)) {
                throw new IllegalArgumentException("No @Param annotation found on query method " + method.getName() + " for parameter " + parameterName);
            }
            String[] parameterValue = rawParameters.get(parameterName);
            String[] value = parameterValue == null ? null : (parameterValue.length == 1 ? parameterValue[0] : parameterValue);
            result[i] = this.conversionService.convert((Object)value, TypeDescriptor.forObject((Object)value), new TypeDescriptor(param));
        }
        return result;
    }

    private <T> T invoke(Method method, Object ... arguments) {
        ReflectionUtils.makeAccessible((Method)method);
        return (T)ReflectionUtils.invokeMethod((Method)method, (Object)this.repository, (Object[])arguments);
    }

    protected Serializable convertId(Serializable id) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        return (Serializable)this.conversionService.convert((Object)id, this.idType);
    }

    protected Iterable<Object> invokeFindAllReflectively(Pageable pageable) {
        Assert.state((boolean)this.hasFindAllMethod(), (String)"Repository doesn't have a find-all-method declared!");
        Method method = this.methods.getFindAllMethod();
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 0) {
            return (Iterable)this.invoke(method, new Object[0]);
        }
        if (Pageable.class.isAssignableFrom(types[0])) {
            return (Iterable)this.invoke(method, pageable);
        }
        Sort sort = pageable == null ? null : pageable.getSort();
        return this.invokeFindAll(sort);
    }

    protected Iterable<Object> invokeFindAllReflectively(Sort sort) {
        Assert.state((boolean)this.hasFindAllMethod(), (String)"Repository doesn't have a find-all-method declared!");
        Method method = this.methods.getFindAllMethod();
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 0) {
            return (Iterable)this.invoke(method, new Object[0]);
        }
        return (Iterable)this.invoke(method, sort);
    }
}

