/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.projection.MapAccessingMethodInterceptor;
import org.springframework.data.projection.ProjectingMethodInterceptor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.PropertyAccessingMethodInterceptor;
import org.springframework.util.Assert;

class ProxyProjectionFactory
implements ProjectionFactory {
    ProxyProjectionFactory() {
    }

    @Override
    public <T> T createProjection(Class<T> projectionType, Object source) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        Assert.isTrue((boolean)projectionType.isInterface(), (String)"Projection type must be an interface!");
        if (source == null) {
            return null;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget(source);
        factory.setOpaque(true);
        factory.setInterfaces(new Class[]{projectionType, TargetClassAware.class});
        factory.addAdvice((Advice)new TargetClassAwareMethodInterceptor(source.getClass()));
        factory.addAdvice((Advice)this.getMethodInterceptor(source, projectionType));
        return (T)factory.getProxy(this.getClass().getClassLoader());
    }

    @Override
    public <T> T createProjection(Class<T> projectionType) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        return this.createProjection(projectionType, new HashMap());
    }

    @Override
    public List<String> getInputProperties(Class<?> projectionType) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        PropertyDescriptor[] descriptors = BeanUtils.getPropertyDescriptors(projectionType);
        ArrayList<String> result = new ArrayList<String>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            if (!this.isInputProperty(descriptor)) continue;
            result.add(descriptor.getName());
        }
        return result;
    }

    private MethodInterceptor getMethodInterceptor(Object source, Class<?> projectionType) {
        Object propertyInvocationInterceptor = source instanceof Map ? new MapAccessingMethodInterceptor((Map)source) : new PropertyAccessingMethodInterceptor(source);
        return new ProjectingMethodInterceptor(this, this.postProcessAccessorInterceptor((MethodInterceptor)propertyInvocationInterceptor, source, projectionType));
    }

    protected MethodInterceptor postProcessAccessorInterceptor(MethodInterceptor interceptor, Object source, Class<?> projectionType) {
        return interceptor;
    }

    protected boolean isInputProperty(PropertyDescriptor descriptor) {
        return true;
    }

    private static class TargetClassAwareMethodInterceptor
    implements MethodInterceptor {
        private static final Method GET_TARGET_CLASS_METHOD;
        private final Class<?> targetClass;

        public TargetClassAwareMethodInterceptor(Class<?> targetClass) {
            Assert.notNull(targetClass, (String)"Target class must not be null!");
            this.targetClass = targetClass;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().equals(GET_TARGET_CLASS_METHOD)) {
                return this.targetClass;
            }
            return invocation.proceed();
        }

        static {
            try {
                GET_TARGET_CLASS_METHOD = TargetClassAware.class.getMethod("getTargetClass", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static interface TargetClassAware
    extends org.springframework.aop.TargetClassAware {
        @JsonIgnore
        public Class<?> getTargetClass();
    }
}

