/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.util.Assert;

public class Parameter {
    static final List<Class<?>> TYPES = Arrays.asList(Pageable.class, Sort.class);
    private static final String NAMED_PARAMETER_TEMPLATE = ":%s";
    private static final String POSITION_PARAMETER_TEMPLATE = "?%s";
    private final MethodParameter parameter;
    private final Class<?> parameterType;

    protected Parameter(MethodParameter parameter) {
        Assert.notNull((Object)parameter);
        this.parameter = parameter;
        this.parameterType = Parameter.potentiallyUnwrapParameterType(parameter);
    }

    public boolean isSpecialParameter() {
        return TYPES.contains(this.parameter.getParameterType());
    }

    public boolean isBindable() {
        return !this.isSpecialParameter();
    }

    public String getPlaceholder() {
        if (this.isNamedParameter()) {
            return String.format(NAMED_PARAMETER_TEMPLATE, this.getName());
        }
        return String.format(POSITION_PARAMETER_TEMPLATE, this.getIndex());
    }

    public int getIndex() {
        return this.parameter.getParameterIndex();
    }

    public boolean isNamedParameter() {
        return !this.isSpecialParameter() && this.getName() != null;
    }

    public String getName() {
        Param annotation = (Param)this.parameter.getParameterAnnotation(Param.class);
        return annotation == null ? this.parameter.getParameterName() : annotation.value();
    }

    public Class<?> getType() {
        return this.parameterType;
    }

    public boolean isExplicitlyNamed() {
        return this.parameter.hasParameterAnnotation(Param.class);
    }

    public String toString() {
        return String.format("%s:%s", this.isNamedParameter() ? this.getName() : "#" + this.getIndex(), this.getType().getName());
    }

    boolean isPageable() {
        return Pageable.class.isAssignableFrom(this.getType());
    }

    boolean isSort() {
        return Sort.class.isAssignableFrom(this.getType());
    }

    private static Class<?> potentiallyUnwrapParameterType(MethodParameter parameter) {
        Class originalType = parameter.getParameterType();
        return QueryExecutionConverters.supports(originalType) ? ResolvableType.forMethodParameter((MethodParameter)parameter).getGeneric(new int[]{0}).getRawClass() : originalType;
    }
}

