/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class DefaultCrudMethods
implements CrudMethods {
    private final RepositoryInformation information;
    private Method findAllMethod;
    private boolean findAllHasPaging;
    private Method findOneMethod;
    private Method saveMethod;
    private Method deleteMethod;

    public DefaultCrudMethods(RepositoryInformation information) {
        Assert.notNull((Object)information, (String)"RepositoryInformation must not be null!");
        this.information = information;
        for (Method method : ReflectionUtils.getAllDeclaredMethods(information.getRepositoryInterface())) {
            if (!information.isBaseClassMethod(method)) continue;
            if (method.getName().equals("findAll")) {
                this.findAllDetected(method);
                continue;
            }
            if (method.getName().equals("findOne")) {
                this.findOneMethod = method;
            }
            if (method.getName().equals("save")) {
                this.saveMethod = method;
            }
            if (!method.getName().equals("delete")) continue;
            this.deleteDetected(method);
        }
    }

    private void findAllDetected(Method method) {
        if (this.findAllMethod != null && this.findAllHasPaging) {
            return;
        }
        Class<?>[] parameterType = method.getParameterTypes();
        if (parameterType.length > 0) {
            if (parameterType[0].equals(Pageable.class)) {
                this.findAllMethod = method;
                this.findAllHasPaging = true;
                return;
            }
            if (parameterType[0].equals(Sort.class)) {
                this.findAllMethod = method;
            }
            return;
        }
        if (this.findAllMethod == null) {
            this.findAllMethod = method;
        }
    }

    private void deleteDetected(Method method) {
        MethodParameter parameter = new MethodParameter(method, 0);
        Class parameterType = GenericTypeResolver.resolveParameterType((MethodParameter)parameter, this.information.getRepositoryInterface());
        if (this.information.getIdType().isAssignableFrom(parameterType)) {
            this.deleteMethod = method;
        }
        if (this.deleteMethod == null) {
            this.deleteMethod = method;
        }
    }

    @Override
    public Method getSaveMethod() {
        return this.saveMethod;
    }

    @Override
    public boolean hasSaveMethod() {
        return this.saveMethod != null;
    }

    @Override
    public Method getFindAllMethod() {
        return this.findAllMethod;
    }

    @Override
    public boolean hasFindAllMethod() {
        return this.findAllMethod != null;
    }

    @Override
    public Method getFindOneMethod() {
        return this.findOneMethod;
    }

    @Override
    public boolean hasFindOneMethod() {
        return this.findOneMethod != null;
    }

    @Override
    public boolean hasDelete() {
        return this.deleteMethod != null;
    }

    @Override
    public Method getDeleteMethod() {
        return this.deleteMethod;
    }
}

