/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.util.Assert;

public class IsNewAwareAuditingHandler
extends AuditingHandler {
    private final IsNewStrategyFactory isNewStrategyFactory;

    public IsNewAwareAuditingHandler(IsNewStrategyFactory isNewStrategyFactory) {
        Assert.notNull((Object)isNewStrategyFactory, (String)"IsNewStrategy must not be null!");
        this.isNewStrategyFactory = isNewStrategyFactory;
    }

    public void markAudited(Object object) {
        if (object == null) {
            return;
        }
        IsNewStrategy strategy = this.isNewStrategyFactory.getIsNewStrategy(object.getClass());
        if (strategy.isNew(object)) {
            this.markCreated(object);
        } else {
            this.markModified(object);
        }
    }
}

