/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.util.ClassUtils;

public abstract class JodaTimeConverters {
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent((String)"org.joda.time.LocalDate", null);

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JODA_TIME_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(LocalDateToDateConverter.INSTANCE);
        converters.add(LocalDateTimeToDateConverter.INSTANCE);
        converters.add(DateTimeToDateConverter.INSTANCE);
        converters.add(DateMidnightToDateConverter.INSTANCE);
        converters.add(DateToLocalDateConverter.INSTANCE);
        converters.add(DateToLocalDateTimeConverter.INSTANCE);
        converters.add(DateToDateTimeConverter.INSTANCE);
        converters.add(DateToDateMidnightConverter.INSTANCE);
        converters.add(LocalDateTimeToJodaLocalDateTime.INSTANCE);
        converters.add(LocalDateTimeToJodaDateTime.INSTANCE);
        return converters;
    }

    public static enum LocalDateTimeToJodaDateTime implements Converter<java.time.LocalDateTime, DateTime>
    {
        INSTANCE;


        public DateTime convert(java.time.LocalDateTime source) {
            return source == null ? null : new DateTime((Object)Jsr310Converters.LocalDateTimeToDateConverter.INSTANCE.convert(source));
        }
    }

    public static enum LocalDateTimeToJodaLocalDateTime implements Converter<java.time.LocalDateTime, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(java.time.LocalDateTime source) {
            return source == null ? null : LocalDateTime.fromDateFields((Date)Jsr310Converters.LocalDateTimeToDateConverter.INSTANCE.convert(source));
        }
    }

    public static enum DateToDateMidnightConverter implements Converter<Date, DateMidnight>
    {
        INSTANCE;


        public DateMidnight convert(Date source) {
            return source == null ? null : new DateMidnight(source.getTime());
        }
    }

    public static enum DateToDateTimeConverter implements Converter<Date, DateTime>
    {
        INSTANCE;


        public DateTime convert(Date source) {
            return source == null ? null : new DateTime(source.getTime());
        }
    }

    public static enum DateToLocalDateTimeConverter implements Converter<Date, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Date source) {
            return source == null ? null : new LocalDateTime(source.getTime());
        }
    }

    public static enum DateToLocalDateConverter implements Converter<Date, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Date source) {
            return source == null ? null : new LocalDate(source.getTime());
        }
    }

    public static enum DateMidnightToDateConverter implements Converter<DateMidnight, Date>
    {
        INSTANCE;


        public Date convert(DateMidnight source) {
            return source == null ? null : source.toDate();
        }
    }

    public static enum DateTimeToDateConverter implements Converter<DateTime, Date>
    {
        INSTANCE;


        public Date convert(DateTime source) {
            return source == null ? null : source.toDate();
        }
    }

    public static enum LocalDateTimeToDateConverter implements Converter<LocalDateTime, Date>
    {
        INSTANCE;


        public Date convert(LocalDateTime source) {
            return source == null ? null : source.toDate();
        }
    }

    public static enum LocalDateToDateConverter implements Converter<LocalDate, Date>
    {
        INSTANCE;


        public Date convert(LocalDate source) {
            return source == null ? null : source.toDate();
        }
    }
}

