/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.MappingInstantiationException;
import org.springframework.data.mapping.model.ParameterValueProvider;

public enum ReflectionEntityInstantiator implements EntityInstantiator
{
    INSTANCE;


    @Override
    public <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T createInstance(E entity, ParameterValueProvider<P> provider) {
        return (T)entity.getPersistenceConstructor().map(constructor -> {
            List params = Optional.ofNullable(provider).map(it -> constructor.getParameters().stream().map(parameter -> it.getParameterValue(parameter).orElse(Optional.empty())).collect(Collectors.toList())).orElseGet(Collections::emptyList);
            ArrayList foo = new ArrayList(params.size());
            for (Object element : params) {
                foo.add(element instanceof Optional ? null : (Object)element);
            }
            try {
                return BeanUtils.instantiateClass(constructor.getConstructor(), (Object[])foo.toArray());
            }
            catch (BeanInstantiationException e) {
                throw new MappingInstantiationException(Optional.of(entity), params, (Exception)((Object)e));
            }
        }).orElseGet(() -> {
            try {
                Class clazz = entity.getType();
                if (clazz.isArray()) {
                    Class<Object> ctype = clazz;
                    int dims = 0;
                    while (ctype.isArray()) {
                        ctype = ctype.getComponentType();
                        ++dims;
                    }
                    return Array.newInstance(clazz, dims);
                }
                return BeanUtils.instantiateClass(clazz);
            }
            catch (BeanInstantiationException e) {
                throw new MappingInstantiationException(Optional.of(entity), Collections.emptyList(), (Exception)((Object)e));
            }
        });
    }
}

