/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.util.Optional;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;

public abstract class AbstractEntityInformation<T, ID extends Serializable>
implements EntityInformation<T, ID> {
    private final Class<T> domainClass;

    public AbstractEntityInformation(Class<T> domainClass) {
        Assert.notNull(domainClass, (String)"DomainClass must not be null!");
        this.domainClass = domainClass;
    }

    @Override
    public boolean isNew(T entity) {
        Optional id = this.getId(entity);
        Class idType = this.getIdType();
        if (!idType.isPrimitive()) {
            return !id.isPresent();
        }
        return id.map(it -> {
            if (it instanceof Number) {
                return ((Number)it).longValue() == 0L;
            }
            return null;
        }).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported primitive id type %s!", idType)));
    }

    @Override
    public Class<T> getJavaType() {
        return this.domainClass;
    }
}

