/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.util.Optional;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class PersistentEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID> {
    private final PersistentEntity<T, ? extends PersistentProperty<?>> persistentEntity;

    public PersistentEntityInformation(PersistentEntity<T, ?> entity) {
        super(entity.getType());
        this.persistentEntity = entity;
    }

    @Override
    public Optional<ID> getId(T entity) {
        return this.persistentEntity.getIdentifierAccessor(entity).getIdentifier().map(it -> (Serializable)it);
    }

    @Override
    public Class<ID> getIdType() {
        return this.persistentEntity.getIdProperty().map(PersistentProperty::getType).orElse(null);
    }
}

