/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class Repositories
implements Iterable<Class<?>> {
    static final Repositories NONE = new Repositories();
    private static final RepositoryFactoryInformation<Object, Serializable> EMPTY_REPOSITORY_FACTORY_INFO = EmptyRepositoryFactoryInformation.INSTANCE;
    private static final String DOMAIN_TYPE_MUST_NOT_BE_NULL = "Domain type must not be null!";
    private final Optional<BeanFactory> beanFactory;
    private final Map<Class<?>, String> repositoryBeanNames;
    private final Map<Class<?>, RepositoryFactoryInformation<Object, Serializable>> repositoryFactoryInfos;

    private Repositories() {
        this.beanFactory = Optional.empty();
        this.repositoryBeanNames = Collections.emptyMap();
        this.repositoryFactoryInfos = Collections.emptyMap();
    }

    public Repositories(ListableBeanFactory factory) {
        Assert.notNull((Object)factory, (String)"ListableBeanFactory must not be null!");
        this.beanFactory = Optional.of(factory);
        this.repositoryFactoryInfos = new HashMap();
        this.repositoryBeanNames = new HashMap();
        this.populateRepositoryFactoryInformation(factory);
    }

    private void populateRepositoryFactoryInformation(ListableBeanFactory factory) {
        for (String name : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)factory, RepositoryFactoryInformation.class, (boolean)false, (boolean)false)) {
            this.cacheRepositoryFactory(name);
        }
    }

    private synchronized void cacheRepositoryFactory(String name) {
        RepositoryFactoryInformation repositoryFactoryInformation = (RepositoryFactoryInformation)this.beanFactory.get().getBean(name, RepositoryFactoryInformation.class);
        Class domainType = ClassUtils.getUserClass(repositoryFactoryInformation.getRepositoryInformation().getDomainType());
        RepositoryInformation information = repositoryFactoryInformation.getRepositoryInformation();
        Set<Class<?>> alternativeDomainTypes = information.getAlternativeDomainTypes();
        String beanName = BeanFactoryUtils.transformedBeanName((String)name);
        HashSet typesToRegister = new HashSet(alternativeDomainTypes.size() + 1);
        typesToRegister.add(domainType);
        typesToRegister.addAll(alternativeDomainTypes);
        for (Class clazz : typesToRegister) {
            this.repositoryFactoryInfos.put(clazz, repositoryFactoryInformation);
            this.repositoryBeanNames.put(clazz, beanName);
        }
    }

    public boolean hasRepositoryFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)DOMAIN_TYPE_MUST_NOT_BE_NULL);
        return this.repositoryFactoryInfos.containsKey(domainClass);
    }

    public Optional<Object> getRepositoryFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)DOMAIN_TYPE_MUST_NOT_BE_NULL);
        Optional<String> repositoryBeanName = Optional.ofNullable(this.repositoryBeanNames.get(domainClass));
        return this.beanFactory.flatMap(it -> repositoryBeanName.map(arg_0 -> ((BeanFactory)it).getBean(arg_0)));
    }

    private RepositoryFactoryInformation<Object, Serializable> getRepositoryFactoryInfoFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)DOMAIN_TYPE_MUST_NOT_BE_NULL);
        Class userType = ClassUtils.getUserClass(domainClass);
        RepositoryFactoryInformation<Object, Serializable> repositoryInfo = this.repositoryFactoryInfos.get(userType);
        if (repositoryInfo != null) {
            return repositoryInfo;
        }
        if (!userType.equals(Object.class)) {
            return this.getRepositoryFactoryInfoFor(userType.getSuperclass());
        }
        return EMPTY_REPOSITORY_FACTORY_INFO;
    }

    public <T, S extends Serializable> EntityInformation<T, S> getEntityInformationFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)DOMAIN_TYPE_MUST_NOT_BE_NULL);
        return this.getRepositoryFactoryInfoFor(domainClass).getEntityInformation();
    }

    public Optional<RepositoryInformation> getRepositoryInformationFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)DOMAIN_TYPE_MUST_NOT_BE_NULL);
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepositoryFactoryInfoFor(domainClass);
        return information == EMPTY_REPOSITORY_FACTORY_INFO ? Optional.empty() : Optional.of(information.getRepositoryInformation());
    }

    public RepositoryInformation getRequiredRepositoryInformation(Class<?> domainType) {
        return this.getRepositoryInformationFor(domainType).orElseThrow(() -> new IllegalArgumentException("No required RepositoryInformation found for domain type " + domainType.getName() + "!"));
    }

    public Optional<RepositoryInformation> getRepositoryInformation(Class<?> repositoryInterface) {
        return this.repositoryFactoryInfos.values().stream().map(RepositoryFactoryInformation::getRepositoryInformation).filter(information -> information.getRepositoryInterface().equals(repositoryInterface)).findFirst();
    }

    public PersistentEntity<?, ?> getPersistentEntity(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)DOMAIN_TYPE_MUST_NOT_BE_NULL);
        return this.getRepositoryFactoryInfoFor(domainClass).getPersistentEntity();
    }

    public List<QueryMethod> getQueryMethodsFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)DOMAIN_TYPE_MUST_NOT_BE_NULL);
        return this.getRepositoryFactoryInfoFor(domainClass).getQueryMethods();
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.repositoryFactoryInfos.keySet().iterator();
    }

    private static enum EmptyRepositoryFactoryInformation implements RepositoryFactoryInformation<Object, Serializable>
    {
        INSTANCE;


        @Override
        public EntityInformation<Object, Serializable> getEntityInformation() {
            return null;
        }

        @Override
        public RepositoryInformation getRepositoryInformation() {
            return null;
        }

        @Override
        public PersistentEntity<?, ?> getPersistentEntity() {
            return null;
        }

        @Override
        public List<QueryMethod> getQueryMethods() {
            return Collections.emptyList();
        }
    }
}

