/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertyPath
implements Streamable<PropertyPath> {
    private static final String DELIMITERS = "_\\.";
    private static final String ALL_UPPERCASE = "[A-Z0-9._$]+";
    private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
    private static final Pattern SPLITTER_FOR_QUOTED = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "\\."));
    private final TypeInformation<?> owningType;
    private final String name;
    private final TypeInformation<?> typeInformation;
    private final TypeInformation<?> actualTypeInformation;
    private final boolean isCollection;
    private PropertyPath next;

    PropertyPath(String name, Class<?> owningType) {
        this(name, ClassTypeInformation.from(owningType), Collections.emptyList());
    }

    PropertyPath(String name, TypeInformation<?> owningType, List<PropertyPath> base) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        Assert.notNull(owningType, (String)"Owning type must not be null!");
        Assert.notNull(base, (String)"Perviously found properties must not be null!");
        String propertyName = name.matches(ALL_UPPERCASE) ? name : StringUtils.uncapitalize((String)name);
        TypeInformation<?> propertyType = owningType.getProperty(propertyName).orElseThrow(() -> new PropertyReferenceException(propertyName, owningType, base));
        this.owningType = owningType;
        this.typeInformation = propertyType;
        this.isCollection = propertyType.isCollectionLike();
        this.actualTypeInformation = propertyType.getActualType();
        this.name = propertyName;
    }

    public TypeInformation<?> getOwningType() {
        return this.owningType;
    }

    public String getSegment() {
        return this.name;
    }

    public PropertyPath getLeafProperty() {
        PropertyPath result = this;
        while (result.hasNext()) {
            result = result.next();
        }
        return result;
    }

    public Class<?> getType() {
        return this.actualTypeInformation.getType();
    }

    public PropertyPath next() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public String toDotPath() {
        if (this.hasNext()) {
            return this.getSegment() + "." + this.next().toDotPath();
        }
        return this.getSegment();
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    @Override
    public Iterator<PropertyPath> iterator() {
        return new Iterator<PropertyPath>(){
            private PropertyPath current;
            {
                this.current = PropertyPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public PropertyPath next() {
                PropertyPath result = this.current;
                this.current = this.current.next();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PropertyPath from(String source, Class<?> type) {
        return PropertyPath.from(source, ClassTypeInformation.from(type));
    }

    public static PropertyPath from(String source, TypeInformation<?> type) {
        Matcher matcher;
        Assert.hasText((String)source, (String)"Source must not be null or empty!");
        Assert.notNull(type, (String)"TypeInformation must not be null or empty!");
        ArrayList<String> iteratorSource = new ArrayList<String>();
        Matcher matcher2 = matcher = PropertyPath.isQuoted(source) ? SPLITTER_FOR_QUOTED.matcher(source.replace("\\Q", "").replace("\\E", "")) : SPLITTER.matcher("_" + source);
        while (matcher.find()) {
            iteratorSource.add(matcher.group(1));
        }
        Iterator parts = iteratorSource.iterator();
        PropertyPath result = null;
        Stack<PropertyPath> current = new Stack<PropertyPath>();
        while (parts.hasNext()) {
            if (result == null) {
                result = PropertyPath.create((String)parts.next(), type, current);
                current.push(result);
                continue;
            }
            current.push(PropertyPath.create((String)parts.next(), current));
        }
        return result;
    }

    private static boolean isQuoted(String source) {
        return source.matches("^\\\\Q.*\\\\E$");
    }

    private static PropertyPath create(String source, Stack<PropertyPath> base) {
        PropertyPath propertyPath;
        PropertyPath previous = base.peek();
        previous.next = propertyPath = PropertyPath.create(source, previous.typeInformation.getActualType(), base);
        return propertyPath;
    }

    private static PropertyPath create(String source, TypeInformation<?> type, List<PropertyPath> base) {
        return PropertyPath.create(source, type, "", base);
    }

    private static PropertyPath create(String source, TypeInformation<?> type, String addTail, List<PropertyPath> base) {
        PropertyReferenceException exception = null;
        PropertyPath current = null;
        try {
            current = new PropertyPath(source, type, base);
            if (!base.isEmpty()) {
                base.get((int)(base.size() - 1)).next = current;
            }
            ArrayList<PropertyPath> newBase = new ArrayList<PropertyPath>(base);
            newBase.add(current);
            if (StringUtils.hasText((String)addTail)) {
                current.next = PropertyPath.create(addTail, current.actualTypeInformation, newBase);
            }
            return current;
        }
        catch (PropertyReferenceException e) {
            if (current != null) {
                throw e;
            }
            exception = e;
            Pattern pattern = Pattern.compile("\\p{Lu}+\\p{Ll}*$");
            Matcher matcher = pattern.matcher(source);
            if (matcher.find() && matcher.start() != 0) {
                int position = matcher.start();
                String head = source.substring(0, position);
                String tail = source.substring(position);
                try {
                    return PropertyPath.create(head, type, tail + addTail, base);
                }
                catch (PropertyReferenceException e2) {
                    throw e2.hasDeeperResolutionDepthThan(exception) ? e2 : exception;
                }
            }
            throw exception;
        }
    }

    public String toString() {
        return String.format("%s.%s", this.owningType.getType().getSimpleName(), this.toDotPath());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyPath)) {
            return false;
        }
        PropertyPath other = (PropertyPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TypeInformation<?> this$owningType = this.getOwningType();
        TypeInformation<?> other$owningType = other.getOwningType();
        if (this$owningType == null ? other$owningType != null : !this$owningType.equals(other$owningType)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TypeInformation<?> this$typeInformation = this.getTypeInformation();
        TypeInformation<?> other$typeInformation = other.getTypeInformation();
        if (this$typeInformation == null ? other$typeInformation != null : !this$typeInformation.equals(other$typeInformation)) {
            return false;
        }
        TypeInformation<?> this$actualTypeInformation = this.actualTypeInformation;
        TypeInformation<?> other$actualTypeInformation = other.actualTypeInformation;
        if (this$actualTypeInformation == null ? other$actualTypeInformation != null : !this$actualTypeInformation.equals(other$actualTypeInformation)) {
            return false;
        }
        if (this.isCollection() != other.isCollection()) {
            return false;
        }
        PropertyPath this$next = this.next;
        PropertyPath other$next = other.next;
        return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeInformation<?> $owningType = this.getOwningType();
        result = result * 59 + ($owningType == null ? 43 : $owningType.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TypeInformation<?> $typeInformation = this.getTypeInformation();
        result = result * 59 + ($typeInformation == null ? 43 : $typeInformation.hashCode());
        TypeInformation<?> $actualTypeInformation = this.actualTypeInformation;
        result = result * 59 + ($actualTypeInformation == null ? 43 : $actualTypeInformation.hashCode());
        result = result * 59 + (this.isCollection() ? 79 : 97);
        PropertyPath $next = this.next;
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        return result;
    }

    public TypeInformation<?> getTypeInformation() {
        return this.typeInformation;
    }
}

